"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSLO = void 0;
var _uuid = require("uuid");
var _models = require("../../domain/models");
var _services = require("../../domain/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CreateSLO {
  constructor(resourceInstaller, repository, transformManager) {
    this.resourceInstaller = resourceInstaller;
    this.repository = repository;
    this.transformManager = transformManager;
  }
  async execute(params) {
    const slo = this.toSLO(params);
    (0, _services.validateSLO)(slo);
    await this.resourceInstaller.ensureCommonResourcesInstalled();
    await this.repository.save(slo);
    let sloTransformId;
    try {
      sloTransformId = await this.transformManager.install(slo);
    } catch (err) {
      await this.repository.deleteById(slo.id);
      throw err;
    }
    try {
      await this.transformManager.start(sloTransformId);
    } catch (err) {
      await Promise.all([this.transformManager.uninstall(sloTransformId), this.repository.deleteById(slo.id)]);
      throw err;
    }
    return this.toResponse(slo);
  }
  toSLO(params) {
    var _params$settings$sync, _params$settings, _params$settings$freq, _params$settings2, _params$tags;
    const now = new Date();
    return {
      ...params,
      id: (0, _uuid.v1)(),
      settings: {
        syncDelay: (_params$settings$sync = (_params$settings = params.settings) === null || _params$settings === void 0 ? void 0 : _params$settings.syncDelay) !== null && _params$settings$sync !== void 0 ? _params$settings$sync : new _models.Duration(1, _models.DurationUnit.Minute),
        frequency: (_params$settings$freq = (_params$settings2 = params.settings) === null || _params$settings2 === void 0 ? void 0 : _params$settings2.frequency) !== null && _params$settings$freq !== void 0 ? _params$settings$freq : new _models.Duration(1, _models.DurationUnit.Minute)
      },
      revision: 1,
      enabled: true,
      tags: (_params$tags = params.tags) !== null && _params$tags !== void 0 ? _params$tags : [],
      createdAt: now,
      updatedAt: now
    };
  }
  toResponse(slo) {
    return {
      id: slo.id
    };
  }
}
exports.CreateSLO = CreateSLO;