"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _server2 = require("@kbn/rule-registry-plugin/server");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _common = require("@kbn/cases-plugin/common");
var _common2 = require("@kbn/alerting-plugin/common");
var _kubernetes_guide_config = require("../common/guided_onboarding/kubernetes_guide_config");
var _bootstrap_annotations = require("./lib/annotations/bootstrap_annotations");
var _ui_settings = require("./ui_settings");
var _register_routes = require("./routes/register_routes");
var _get_global_observability_server_route_repository = require("./routes/get_global_observability_server_route_repository");
var _common3 = require("../common");
var _saved_objects2 = require("./saved_objects");
var _constants = require("./common/constants");
var _register_rule_types = require("./lib/rules/register_rule_types");
var _constants2 = require("../common/constants");
var _register = require("./lib/collectors/register");
var _field_map = require("./lib/rules/slo_burn_rate/field_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initContext = initContext;
    this.initContext = initContext;
    this.logger = initContext.logger.get();
  }
  setup(core, plugins) {
    const casesCapabilities = (0, _common.createUICapabilities)();
    const casesApiTags = (0, _common.getApiTags)(_common3.observabilityFeatureId);
    const config = this.initContext.config.get();
    plugins.features.registerKibanaFeature({
      id: _common3.casesFeatureId,
      name: _i18n.i18n.translate('xpack.observability.featureRegistry.linkObservabilityTitle', {
        defaultMessage: 'Cases'
      }),
      order: 1100,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      app: [_common3.casesFeatureId, 'kibana'],
      catalogue: [_common3.observabilityFeatureId],
      cases: [_common3.observabilityFeatureId],
      privileges: {
        all: {
          api: casesApiTags.all,
          app: [_common3.casesFeatureId, 'kibana'],
          catalogue: [_common3.observabilityFeatureId],
          cases: {
            create: [_common3.observabilityFeatureId],
            read: [_common3.observabilityFeatureId],
            update: [_common3.observabilityFeatureId],
            push: [_common3.observabilityFeatureId]
          },
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          ui: casesCapabilities.all
        },
        read: {
          api: casesApiTags.read,
          app: [_common3.casesFeatureId, 'kibana'],
          catalogue: [_common3.observabilityFeatureId],
          cases: {
            read: [_common3.observabilityFeatureId]
          },
          savedObject: {
            all: [],
            read: [..._saved_objects.hiddenTypes]
          },
          ui: casesCapabilities.read
        }
      },
      subFeatures: [{
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureName', {
          defaultMessage: 'Delete'
        }),
        privilegeGroups: [{
          groupType: 'independent',
          privileges: [{
            api: casesApiTags.delete,
            id: 'cases_delete',
            name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureDetails', {
              defaultMessage: 'Delete cases and comments'
            }),
            includeIn: 'all',
            savedObject: {
              all: [..._saved_objects.hiddenTypes],
              read: [..._saved_objects.hiddenTypes]
            },
            cases: {
              delete: [_common3.observabilityFeatureId]
            },
            ui: casesCapabilities.delete
          }]
        }]
      }]
    });
    let annotationsApiPromise;
    core.uiSettings.register(_ui_settings.uiSettings);
    if (config.annotations.enabled) {
      annotationsApiPromise = (0, _bootstrap_annotations.bootstrapAnnotations)({
        core,
        index: config.annotations.index,
        context: this.initContext
      }).catch(err => {
        const logger = this.initContext.logger.get('annotations');
        logger.warn(err);
        throw err;
      });
    }
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    plugins.features.registerKibanaFeature({
      id: _common3.sloFeatureId,
      name: _i18n.i18n.translate('xpack.observability.featureRegistry.linkSloTitle', {
        defaultMessage: 'SLOs'
      }),
      order: 1200,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      app: [_common3.sloFeatureId, 'kibana'],
      catalogue: [_common3.sloFeatureId, 'observability'],
      alerting: [_constants2.SLO_BURN_RATE_RULE_ID],
      privileges: {
        all: {
          app: [_common3.sloFeatureId, 'kibana'],
          catalogue: [_common3.sloFeatureId, 'observability'],
          api: ['slo_write', 'slo_read', 'rac'],
          savedObject: {
            all: [_saved_objects2.SO_SLO_TYPE],
            read: []
          },
          alerting: {
            rule: {
              all: [_constants2.SLO_BURN_RATE_RULE_ID]
            },
            alert: {
              all: [_constants2.SLO_BURN_RATE_RULE_ID]
            }
          },
          ui: ['read', 'write']
        },
        read: {
          app: [_common3.sloFeatureId, 'kibana'],
          catalogue: [_common3.sloFeatureId, 'observability'],
          api: ['slo_read', 'rac'],
          savedObject: {
            all: [],
            read: [_saved_objects2.SO_SLO_TYPE]
          },
          alerting: {
            rule: {
              read: [_constants2.SLO_BURN_RATE_RULE_ID]
            },
            alert: {
              read: [_constants2.SLO_BURN_RATE_RULE_ID]
            }
          },
          ui: ['read']
        }
      }
    });
    core.savedObjects.registerType(_saved_objects2.slo);
    const ruleDataClient = ruleDataService.initializeIndex({
      feature: _common3.sloFeatureId,
      registrationContext: _constants.SLO_RULE_REGISTRATION_CONTEXT,
      dataset: _server2.Dataset.alerts,
      componentTemplateRefs: [],
      componentTemplates: [{
        name: 'mappings',
        mappings: (0, _common2.mappingFromFieldMap)({
          ..._alertsAsDataUtils.legacyExperimentalFieldMap,
          ..._field_map.sloRuleFieldMap
        }, 'strict')
      }]
    });
    (0, _register_rule_types.registerRuleTypes)(plugins.alerting, this.logger, ruleDataClient, core.http.basePath);
    (0, _register.registerSloUsageCollector)(plugins.usageCollection);
    core.getStartServices().then(([coreStart, pluginStart]) => {
      (0, _register_routes.registerRoutes)({
        core,
        dependencies: {
          ruleDataService,
          getRulesClientWithRequest: pluginStart.alerting.getRulesClientWithRequest
        },
        logger: this.logger,
        repository: (0, _get_global_observability_server_route_repository.getObservabilityServerRouteRepository)()
      });
    });

    /**
     * Register a config for the observability guide
     */
    plugins.guidedOnboarding.registerGuideConfig(_kubernetes_guide_config.kubernetesGuideId, _kubernetes_guide_config.kubernetesGuideConfig);
    return {
      getAlertDetailsConfig() {
        return config.unsafe.alertDetails;
      },
      getScopedAnnotationsClient: async (...args) => {
        const api = await annotationsApiPromise;
        return api === null || api === void 0 ? void 0 : api.getScopedAnnotationsClient(...args);
      }
    };
  }
  start() {}
  stop() {}
}
exports.ObservabilityPlugin = ObservabilityPlugin;