"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSliApmParamsToApmAppDeeplinkUrl = convertSliApmParamsToApmAppDeeplinkUrl;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertSliApmParamsToApmAppDeeplinkUrl({
  duration,
  environment,
  filter,
  service,
  transactionName,
  transactionType
}) {
  if (!service) {
    return '';
  }
  const qs = new URLSearchParams('comparisonEnabled=true');
  if (environment) {
    qs.append('environment', environment === '*' ? 'ENVIRONMENT_ALL' : environment);
  }
  if (transactionType) {
    qs.append('transactionType', transactionType === '*' ? '' : transactionType);
  }
  if (duration) {
    qs.append('rangeFrom', `now-${duration}`);
    qs.append('rangeTo', 'now');
  }
  const kueryParams = [];
  if (transactionName && transactionName !== '*') {
    kueryParams.push(`transaction.name : "${transactionName}"`);
  }
  if (filter && filter.length > 0) {
    kueryParams.push(filter);
  }
  if (kueryParams.length > 0) {
    qs.append('kuery', kueryParams.join(' and '));
  }
  return `/app/apm/services/${service}/overview?${qs.toString()}`;
}