"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Prompt = void 0;
var _react = require("react");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line react/function-component-definition
const Prompt = ({
  prompt
}) => {
  const {
    setPrompt
  } = (0, _context.useNavigationWarningPrompt)();
  (0, _react.useEffect)(() => {
    setPrompt(prompt);
    return () => {
      setPrompt(undefined);
    };
  }, [prompt, setPrompt]);
  return null;
};
exports.Prompt = Prompt;