"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateGlobalNavigation = updateGlobalNavigation;
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/cases-plugin/public");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function updateGlobalNavigation({
  capabilities,
  deepLinks,
  updater$
}) {
  const {
    apm,
    logs,
    metrics,
    uptime
  } = capabilities.navLinks;
  const someVisible = Object.values({
    apm,
    logs,
    metrics,
    uptime
  }).some(visible => visible);
  const updatedDeepLinks = deepLinks.map(link => {
    var _capabilities$sloFeat;
    switch (link.id) {
      case _public2.CasesDeepLinkId.cases:
        return {
          ...link,
          navLinkStatus: capabilities[_common.casesFeatureId].read_cases && someVisible ? _public.AppNavLinkStatus.visible : _public.AppNavLinkStatus.hidden
        };
      case 'alerts':
        return {
          ...link,
          navLinkStatus: someVisible ? _public.AppNavLinkStatus.visible : _public.AppNavLinkStatus.hidden
        };
      case 'rules':
        return {
          ...link,
          navLinkStatus: someVisible ? _public.AppNavLinkStatus.visible : _public.AppNavLinkStatus.hidden
        };
      case 'slos':
        return {
          ...link,
          navLinkStatus: !!((_capabilities$sloFeat = capabilities[_common.sloFeatureId]) !== null && _capabilities$sloFeat !== void 0 && _capabilities$sloFeat.read) ? _public.AppNavLinkStatus.visible : _public.AppNavLinkStatus.hidden
        };
      default:
        return link;
    }
  });
  updater$.next(() => {
    var _capabilities$sloFeat2;
    return {
      deepLinks: updatedDeepLinks,
      navLinkStatus: someVisible || !!((_capabilities$sloFeat2 = capabilities[_common.sloFeatureId]) !== null && _capabilities$sloFeat2 !== void 0 && _capabilities$sloFeat2.read) ? _public.AppNavLinkStatus.visible : _public.AppNavLinkStatus.hidden
    };
  });
}