"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNavigationRegistry = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createNavigationRegistry = () => {
  const registeredSections$ = new _rxjs.ReplaySubject();
  const registerSections = sections$ => {
    registeredSections$.next(sections$);
  };
  const sections$ = registeredSections$.pipe((0, _operators.scan)((accumulatedSections$, newSections) => accumulatedSections$.add(newSections), new Set()), (0, _operators.switchMap)(registeredSections => (0, _rxjs.combineLatest)([...registeredSections])), (0, _operators.map)(registeredSections => registeredSections.flat().sort((first, second) => first.sortKey - second.sortKey)), (0, _operators.shareReplay)(1));
  return {
    registerSections,
    sections$
  };
};
exports.createNavigationRegistry = createNavigationRegistry;