"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callObservabilityApi = void 0;
exports.createCallObservabilityApi = createCallObservabilityApi;
var _serverRouteRepository = require("@kbn/server-route-repository");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let callObservabilityApi = () => {
  throw new Error('callObservabilityApi has not been initialized via createCallObservabilityApi');
};
exports.callObservabilityApi = callObservabilityApi;
function createCallObservabilityApi(http) {
  const client = (endpoint, options) => {
    const {
      params: {
        path,
        body,
        query
      } = {},
      ...rest
    } = options;
    const {
      method,
      pathname
    } = (0, _serverRouteRepository.formatRequest)(endpoint, path);
    return http[method](pathname, {
      ...rest,
      body,
      query
    });
  };
  exports.callObservabilityApi = callObservabilityApi = client;
}