"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerObservabilityRuleTypes = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _infra_metrics = require("../../common/field_names/infra_metrics");
var _constants = require("../../common/constants");
var _validation = require("../components/app/burn_rate_rule_editor/validation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const registerObservabilityRuleTypes = (config, observabilityRuleTypeRegistry) => {
  observabilityRuleTypeRegistry.register({
    id: _constants.SLO_BURN_RATE_RULE_ID,
    description: _i18n.i18n.translate('xpack.observability.slo.rules.burnRate.description', {
      defaultMessage: 'Alert when your SLO burn rate is too high over a defined period of time.'
    }),
    format: ({
      fields
    }) => {
      var _fields$ALERT_REASON;
      return {
        reason: (_fields$ALERT_REASON = fields[_ruleDataUtils.ALERT_REASON]) !== null && _fields$ALERT_REASON !== void 0 ? _fields$ALERT_REASON : '-',
        link: `/app/observability/slos/${fields[_infra_metrics.SLO_ID_FIELD]}`
      };
    },
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return 'https://www.elastic.co/guide/en/observability/current/slo-burn-rate-alert.html';
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/app/burn_rate_rule_editor')))),
    validate: _validation.validateBurnRateRule,
    requiresAppContext: false,
    defaultActionMessage: _i18n.i18n.translate('xpack.observability.slo.rules.burnRate.defaultActionMessage', {
      defaultMessage: `The rule \\{\\{rule.name\\}\\} for the SLO '\\{\\{context.sloName\\}\\}' is firing:
- Reason: \\{\\{context.reason\\}\\}
- The burn rate over the last \\{\\{context.longWindow.duration\\}\\} is \\{\\{context.longWindow.burnRate\\}\\}
- The burn rate over the last \\{\\{context.shortWindow.duration\\}\\} is \\{\\{context.shortWindow.burnRate\\}\\}
- The burn rate threshold is set to \\{\\{context.burnRateThreshold\\}\\}
- View in the SLO details page: \\{\\{context.viewInAppUrl\\}\\}`
    })
  });
};
exports.registerObservabilityRuleTypes = registerObservabilityRuleTypes;