"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _date_picker_context = require("../context/date_picker_context");
var _kibana_react = require("../utils/kibana_react");
var _alerts = require("../pages/alerts/alerts");
var _alert_details = require("../pages/alert_details/alert_details");
var _cases = require("../pages/cases/cases");
var _overview = require("../pages/overview/overview");
var _rules = require("../pages/rules/rules");
var _rule_details = require("../pages/rule_details");
var _slos = require("../pages/slos/slos");
var _slos_welcome = require("../pages/slos_welcome/slos_welcome");
var _slo_details = require("../pages/slo_details/slo_details");
var _slo_edit = require("../pages/slo_edit/slo_edit");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Note: React Router DOM <Redirect> component was not working here
// so I've recreated this simple version for this purpose.
function SimpleRedirect({
  to,
  redirectToApp
}) {
  const {
    application: {
      navigateToApp
    }
  } = (0, _kibana_react.useKibana)().services;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    search,
    hash
  } = (0, _reactRouterDom.useLocation)();
  if (redirectToApp) {
    navigateToApp(redirectToApp, {
      path: `/${search}${hash}`,
      replace: true
    });
  } else if (to) {
    history.replace(to);
  }
  return null;
}
const routes = {
  '/': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: "/overview"
      });
    },
    params: {},
    exact: true
  },
  '/landing': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: "/overview"
      });
    },
    params: {},
    exact: true
  },
  '/overview': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_date_picker_context.DatePickerContextProvider, null, /*#__PURE__*/_react.default.createElement(_overview.OverviewPage, null));
    },
    params: {},
    exact: true
  },
  [_common.casesPath]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_cases.CasesPage, null);
    },
    params: {},
    exact: false
  },
  '/alerts': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_alerts.AlertsPage, null);
    },
    params: {
      // Technically gets a '_a' param by using Kibana URL state sync helpers
    },
    exact: true
  },
  '/exploratory-view': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: "/",
        redirectToApp: "exploratory-view"
      });
    },
    params: {},
    exact: true
  },
  '/alerts/rules': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_rules.RulesPage, null);
    },
    params: {},
    exact: true
  },
  '/alerts/rules/:ruleId': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_rule_details.RuleDetailsPage, null);
    },
    params: {},
    exact: true
  },
  '/alerts/:alertId': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_alert_details.AlertDetails, null);
    },
    params: {},
    exact: true
  },
  '/slos': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_slos.SlosPage, null);
    },
    params: {},
    exact: true
  },
  '/slos/create': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_slo_edit.SloEditPage, null);
    },
    params: {},
    exact: true
  },
  '/slos/welcome': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_slos_welcome.SlosWelcomePage, null);
    },
    params: {},
    exact: true
  },
  '/slos/edit/:sloId': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_slo_edit.SloEditPage, null);
    },
    params: {},
    exact: true
  },
  '/slos/:sloId': {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_slo_details.SloDetailsPage, null);
    },
    params: {},
    exact: true
  }
};
exports.routes = routes;