"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlosWelcomePage = SlosWelcomePage;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../utils/kibana_react");
var _use_license = require("../../hooks/use_license");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_capabilities = require("../../hooks/slo/use_capabilities");
var _use_fetch_slo_list = require("../../hooks/slo/use_fetch_slo_list");
var _paths = require("../../config/paths");
var _illustration = _interopRequireDefault(require("./assets/illustration.svg"));
var _use_fetch_global_diagnosis = require("../../hooks/slo/use_fetch_global_diagnosis");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SlosWelcomePage() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const {
    isError: hasErrorInGlobalDiagnosis
  } = (0, _use_fetch_global_diagnosis.useFetchSloGlobalDiagnosis)();
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const hasRightLicense = hasAtLeast('platinum');
  const {
    isLoading,
    sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)();
  const {
    total
  } = sloList || {
    total: 0
  };
  const handleClickCreateSlo = () => {
    navigateToUrl(basePath.prepend(_paths.paths.observability.sloCreate));
  };
  const hasSlosAndHasPermissions = total > 0 && hasAtLeast('platinum') === true && !hasErrorInGlobalDiagnosis;
  (0, _react.useEffect)(() => {
    if (hasSlosAndHasPermissions) {
      navigateToUrl(basePath.prepend(_paths.paths.observability.slos));
    }
  }, [basePath, hasSlosAndHasPermissions, navigateToUrl]);
  return hasSlosAndHasPermissions || isLoading ? null : /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "slosPageWelcomePrompt"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.title', {
      defaultMessage: 'Track and deliver on your SLOs'
    }))),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _illustration.default,
      alt: ""
    }),
    color: "transparent",
    layout: "horizontal",
    hasBorder: false,
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.messageParagraph1', {
      defaultMessage: 'Measure key metrics important to the business, such as service-level indicators and service-level objectives (SLIs/SLOs) to deliver on SLAs.'
    })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.messageParagraph2', {
      defaultMessage: 'Easily report the uptime and reliability of your services to stakeholders with real-time insights.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })),
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasRightLicense ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.getStartedMessage', {
      defaultMessage: 'To get started, create your first SLO.'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11ySloListWelcomePromptCreateSloButton",
      fill: true,
      color: "primary",
      onClick: handleClickCreateSlo,
      disabled: !hasWriteCapabilities || hasErrorInGlobalDiagnosis
    }, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.buttonLabel', {
      defaultMessage: 'Create SLO'
    }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.needLicenseMessage', {
      defaultMessage: 'You need an Elastic Cloud subscription or Platinum license to use SLOs.'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      href: "https://www.elastic.co/cloud/elasticsearch-service/signup",
      target: "_blank",
      "data-test-subj": "slosPageWelcomePromptSignupForCloudButton"
    }, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.signupForCloud', {
      defaultMessage: 'Sign up for Elastic Cloud'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: "https://www.elastic.co/subscriptions",
      target: "_blank",
      "data-test-subj": "slosPageWelcomePromptSignupForLicenseButton"
    }, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.signupForLicense', {
      defaultMessage: 'Sign up for license'
    }))))))),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.learnMore', {
      defaultMessage: 'Want to learn more?'
    }))), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "o11ySloListWelcomePromptReadTheDocsLink",
      href: "https://www.elastic.co/guide/en/observability/current/slo.html",
      target: "_blank"
    }, _i18n.i18n.translate('xpack.observability.slo.sloList.welcomePrompt.learnMoreLink', {
      defaultMessage: 'Read the docs'
    })))
  }));
}