"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloSummary = SloSummary;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../utils/kibana_react");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _i18n2 = require("../../../../common/i18n");
var _slo_sparkline = require("./slo_sparkline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloSummary({
  slo,
  historicalSummary = [],
  historicalSummaryLoading
}) {
  const {
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const isSloFailed = slo.summary.status === 'VIOLATED' || slo.summary.status === 'DEGRADING';
  const titleColor = isSloFailed ? 'danger' : '';
  const errorBudgetBurnDownData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'error_budget_remaining');
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'sli_value');
  const errorBudgetRemaining = slo.summary.errorBudget.remaining <= 0 ? Math.trunc(slo.summary.errorBudget.remaining * 100) / 100 : slo.summary.errorBudget.remaining;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    description: _i18n.i18n.translate('xpack.observability.slo.slo.stats.objective', {
      defaultMessage: '{objective} target',
      values: {
        objective: (0, _numeral.default)(slo.objective.target).format(percentFormat)
      }
    }),
    title: slo.summary.status === 'NO_DATA' ? _i18n2.NOT_AVAILABLE_LABEL : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat),
    textAlign: "right",
    titleColor: titleColor,
    titleSize: "m",
    reverse: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_sparkline.SloSparkline, {
    chart: "line",
    id: "sli_history",
    state: isSloFailed ? 'error' : 'success',
    data: historicalSliData,
    isLoading: historicalSummaryLoading
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 220
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    description: _i18n.i18n.translate('xpack.observability.slo.slo.stats.budgetRemaining', {
      defaultMessage: 'Budget remaining'
    }),
    textAlign: "right",
    title: (0, _numeral.default)(errorBudgetRemaining).format(percentFormat),
    titleColor: titleColor,
    titleSize: "m",
    reverse: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_sparkline.SloSparkline, {
    chart: "area",
    id: "error_budget_burn_down",
    state: isSloFailed ? 'error' : 'success',
    data: errorBudgetBurnDownData,
    isLoading: historicalSummaryLoading
  })))));
}