"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloSparkline = SloSparkline;
var _charts = require("@elastic/charts");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _eui_charts_theme = require("@elastic/eui/dist/eui_charts_theme");
var _kibana_react = require("../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloSparkline({
  chart,
  data,
  id,
  isLoading,
  state
}) {
  const charts = (0, _kibana_react.useKibana)().services.charts;
  const theme = charts.theme.useChartsTheme();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const color = state === 'error' ? euiTheme.colors.danger : euiTheme.colors.success;
  const ChartComponent = chart === 'area' ? _charts.AreaSeries : _charts.LineSeries;
  const LineAxisComponent = chart === 'line' ? /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "axis",
    hide: true,
    domain: {
      min: 0,
      max: 1
    },
    showGridLines: false
  }) : null;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      style: {
        minWidth: 60,
        justifyContent: 'center'
      },
      size: "m",
      mono: true
    });
  }
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 28,
      width: 60
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: false,
    theme: [theme, _eui_charts_theme.EUI_SPARKLINE_THEME_PARTIAL],
    tooltip: "none"
  }), LineAxisComponent, /*#__PURE__*/_react.default.createElement(ChartComponent, {
    color: color,
    data: data,
    fit: _charts.Fit.Nearest,
    id: id,
    lineSeriesStyle: {
      point: {
        visible: false
      }
    },
    xAccessor: 'key',
    xScaleType: _charts.ScaleType.Time,
    yAccessors: ['value'],
    yScaleType: _charts.ScaleType.Linear
  }));
}