"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListSearchFilterSortBar = SloListSearchFilterSortBar;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _labels = require("../../../utils/slo/labels");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SORT_OPTIONS = [{
  label: _i18n.i18n.translate('xpack.observability.slo.list.sortBy.creationTime', {
    defaultMessage: 'Creation time'
  }),
  type: 'creationTime',
  checked: 'on'
}, {
  label: _i18n.i18n.translate('xpack.observability.slo.list.sortBy.indicatorType', {
    defaultMessage: 'Indicator type'
  }),
  type: 'indicatorType'
}];
const INDICATOR_TYPE_OPTIONS = [{
  label: _labels.INDICATOR_APM_LATENCY,
  type: 'sli.apm.transactionDuration'
}, {
  label: _labels.INDICATOR_APM_AVAILABILITY,
  type: 'sli.apm.transactionErrorRate'
}, {
  label: _labels.INDICATOR_CUSTOM_KQL,
  type: 'sli.kql.custom'
}];
function SloListSearchFilterSortBar({
  loading,
  onChangeQuery,
  onChangeSort,
  onChangeIndicatorTypeFilter
}) {
  const [isFilterPopoverOpen, setFilterPopoverOpen] = (0, _react.useState)(false);
  const [isSortPopoverOpen, setSortPopoverOpen] = (0, _react.useState)(false);
  const [sortOptions, setSortOptions] = (0, _react.useState)(SORT_OPTIONS);
  const [indicatorTypeOptions, setIndicatorTypeOptions] = (0, _react.useState)(INDICATOR_TYPE_OPTIONS);
  const selectedSort = sortOptions.find(option => option.checked === 'on');
  const selectedIndicatorTypeFilter = indicatorTypeOptions.filter(option => option.checked === 'on');
  const handleToggleFilterButton = () => setFilterPopoverOpen(!isFilterPopoverOpen);
  const handleToggleSortButton = () => setSortPopoverOpen(!isSortPopoverOpen);
  const handleChangeSort = newOptions => {
    setSortOptions(newOptions);
    setSortPopoverOpen(false);
  };
  const handleChangeIndicatorTypeOptions = newOptions => {
    setIndicatorTypeOptions(newOptions);
    onChangeIndicatorTypeFilter(newOptions.filter(option => option.checked === 'on').map(option => option.type));
  };
  (0, _react.useEffect)(() => {
    if ((selectedSort === null || selectedSort === void 0 ? void 0 : selectedSort.type) === 'creationTime' || (selectedSort === null || selectedSort === void 0 ? void 0 : selectedSort.type) === 'indicatorType') {
      onChangeSort(selectedSort.type);
    }
  }, [onChangeSort, selectedSort]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "o11ySloListSearchFilterSortBarFieldSearch",
    fullWidth: true,
    isLoading: loading,
    onChange: onChangeQuery,
    placeholder: _i18n.i18n.translate('xpack.observability.slo.list.search', {
      defaultMessage: 'Search'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: handleToggleFilterButton,
      isSelected: isFilterPopoverOpen,
      numFilters: selectedIndicatorTypeFilter.length
    }, _i18n.i18n.translate('xpack.observability.slo.list.indicatorTypeFilter', {
      defaultMessage: 'Indicator type'
    })),
    isOpen: isFilterPopoverOpen,
    closePopover: handleToggleFilterButton,
    panelPaddingSize: "none",
    anchorPosition: "downCenter"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('xpack.observability.slo.list.indicatorTypeFilter', {
    defaultMessage: 'Indicator type'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: indicatorTypeOptions,
    onChange: handleChangeIndicatorTypeOptions
  }, list => list))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: handleToggleSortButton,
      isSelected: isSortPopoverOpen
    }, _i18n.i18n.translate('xpack.observability.slo.list.sortByType', {
      defaultMessage: 'Sort by {type}',
      values: {
        type: (selectedSort === null || selectedSort === void 0 ? void 0 : selectedSort.label.toLowerCase()) || ''
      }
    })),
    isOpen: isSortPopoverOpen,
    closePopover: handleToggleSortButton,
    panelPaddingSize: "none",
    anchorPosition: "downCenter"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('xpack.observability.slo.list.sortBy', {
    defaultMessage: 'Sort by'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    singleSelection: true,
    options: sortOptions,
    onChange: handleChangeSort
  }, list => list))))));
}