"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListItems = SloListItems;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_fetch_active_alerts = require("../../../hooks/slo/use_fetch_active_alerts");
var _use_fetch_rules_for_slo = require("../../../hooks/slo/use_fetch_rules_for_slo");
var _use_fetch_historical_summary = require("../../../hooks/slo/use_fetch_historical_summary");
var _use_delete_slo = require("../../../hooks/slo/use_delete_slo");
var _slo_list_item = require("./slo_list_item");
var _slo_list_empty = require("./slo_list_empty");
var _slo_list_error = require("./slo_list_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloListItems({
  sloList,
  loading,
  error
}) {
  const sloIds = sloList.map(slo => slo.id);
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIds
  });
  const {
    data: rulesBySlo
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds
  });
  const {
    isLoading: historicalSummaryLoading,
    sloHistoricalSummaryResponse
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloIds
  });
  const {
    mutate: deleteSlo
  } = (0, _use_delete_slo.useDeleteSlo)();
  if (!loading && !error && sloList.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_empty.SloListEmpty, null);
  }
  if (!loading && error) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_error.SloListError, null);
  }
  const handleDelete = slo => {
    deleteSlo({
      id: slo.id,
      name: slo.name
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, sloList.map(slo => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: slo.id
  }, /*#__PURE__*/_react.default.createElement(_slo_list_item.SloListItem, {
    activeAlerts: activeAlertsBySlo[slo.id],
    rules: rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo.id],
    historicalSummary: sloHistoricalSummaryResponse === null || sloHistoricalSummaryResponse === void 0 ? void 0 : sloHistoricalSummaryResponse[slo.id],
    historicalSummaryLoading: historicalSummaryLoading,
    slo: slo,
    onConfirmDelete: handleDelete
  }))));
}