"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDeleteConfirmationModal = SloDeleteConfirmationModal;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloDeleteConfirmationModal({
  slo: {
    name
  },
  onCancel,
  onConfirm
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    "data-test-subj": "sloDeleteConfirmationModal",
    title: _i18n.i18n.translate('xpack.observability.slo.slo.deleteConfirmationModal.title', {
      defaultMessage: 'Are you sure?'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.observability.slo.slo.deleteConfirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.observability.slo.slo.deleteConfirmationModal.deleteButtonLabel', {
      defaultMessage: 'Delete {name}',
      values: {
        name
      }
    }),
    onCancel: onCancel,
    onConfirm: onConfirm
  }, _i18n.i18n.translate('xpack.observability.slo.slo.deleteConfirmationModal.descriptionText', {
    defaultMessage: "You can't recover {name} after deleting.",
    values: {
      name
    }
  }));
}