"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloBadges = SloBadges;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _slo_indicator_type_badge = require("./slo_indicator_type_badge");
var _slo_status_badge = require("../../../../components/slo/slo_status_badge");
var _slo_active_alerts_badge = require("../../../../components/slo/slo_status_badge/slo_active_alerts_badge");
var _slo_time_window_badge = require("./slo_time_window_badge");
var _slo_rules_badge = require("./slo_rules_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloBadges({
  activeAlerts,
  isLoading,
  rules,
  slo,
  onClickRuleBadge
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: true,
    contentAriaLabel: "Loading",
    width: "54.16px",
    height: "20px",
    borderRadius: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: true,
    contentAriaLabel: "Loading",
    width: "54.16px",
    height: "20px",
    borderRadius: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: true,
    contentAriaLabel: "Loading",
    width: "54.16px",
    height: "20px",
    borderRadius: "s"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_slo_status_badge.SloStatusBadge, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_slo_indicator_type_badge.SloIndicatorTypeBadge, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_slo_time_window_badge.SloTimeWindowBadge, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_slo_active_alerts_badge.SloActiveAlertsBadge, {
    slo: slo,
    activeAlerts: activeAlerts
  }), /*#__PURE__*/_react.default.createElement(_slo_rules_badge.SloRulesBadge, {
    rules: rules,
    onClick: onClickRuleBadge
  })));
}