"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditPage = SloEditPage;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _paths = require("../../config/paths");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _use_fetch_slo_details = require("../../hooks/slo/use_fetch_slo_details");
var _use_license = require("../../hooks/use_license");
var _use_capabilities = require("../../hooks/slo/use_capabilities");
var _use_fetch_global_diagnosis = require("../../hooks/slo/use_fetch_global_diagnosis");
var _feedback_button = require("../../components/slo/feedback_button/feedback_button");
var _slo_edit_form = require("./components/slo_edit_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloEditPage() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const {
    isError: hasErrorInGlobalDiagnosis
  } = (0, _use_fetch_global_diagnosis.useFetchSloGlobalDiagnosis)();
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    sloId
  } = (0, _reactRouterDom.useParams)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const hasRightLicense = hasAtLeast('platinum');
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.observability.slos),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.sloEditLinkText', {
      defaultMessage: 'SLOs'
    })
  }]);
  const {
    slo,
    isInitialLoading
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId
  });
  if (hasRightLicense === false || !hasWriteCapabilities || hasErrorInGlobalDiagnosis) {
    navigateToUrl(basePath.prepend(_paths.paths.observability.slos));
  }
  if (sloId && isInitialLoading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: slo ? _i18n.i18n.translate('xpack.observability.sloEditPageTitle', {
        defaultMessage: 'Edit SLO'
      }) : _i18n.i18n.translate('xpack.observability.sloCreatePageTitle', {
        defaultMessage: 'Create new SLO'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_feedback_button.FeedbackButton, null)],
      bottomBorder: false
    },
    "data-test-subj": "slosEditPage"
  }, /*#__PURE__*/_react.default.createElement(_slo_edit_form.SloEditForm, {
    slo: slo
  }));
}