"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSectionFormValidation = useSectionFormValidation;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSectionFormValidation({
  getFieldState,
  getValues,
  formState,
  watch
}) {
  let isIndicatorSectionValid = false;
  switch (watch('indicator.type')) {
    case 'sli.kql.custom':
      isIndicatorSectionValid = ['indicator.params.index', 'indicator.params.filter', 'indicator.params.good', 'indicator.params.total', 'indicator.params.timestampField'].every(field => !getFieldState(field).invalid) && ['indicator.params.index', 'indicator.params.timestampField'].every(field => !!getValues(field));
      break;
    case 'sli.apm.transactionDuration':
      isIndicatorSectionValid = ['indicator.params.service', 'indicator.params.environment', 'indicator.params.transactionType', 'indicator.params.transactionName', 'indicator.params.threshold'].every(field => !getFieldState(field, formState).invalid && getValues(field) !== '') && !getFieldState('indicator.params.index', formState).invalid;
      break;
    case 'sli.apm.transactionErrorRate':
      isIndicatorSectionValid = ['indicator.params.service', 'indicator.params.environment', 'indicator.params.transactionType', 'indicator.params.transactionName'].every(field => !getFieldState(field, formState).invalid && getValues(field) !== '') && ['indicator.params.index'].every(field => !getFieldState(field, formState).invalid);
      break;
    default:
      isIndicatorSectionValid = false;
      break;
  }
  const isObjectiveSectionValid = ['budgetingMethod', 'timeWindow.duration', 'objective.target', 'objective.timesliceTarget', 'objective.timesliceWindow'].every(field => getFieldState(field).error === undefined);
  const isDescriptionSectionValid = !getFieldState('name').invalid && getValues('name') !== '' && !getFieldState('description').invalid;
  return {
    isIndicatorSectionValid,
    isObjectiveSectionValid,
    isDescriptionSectionValid
  };
}