"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSloResponseToCreateSloInput = transformSloResponseToCreateSloInput;
exports.transformValuesToCreateSLOInput = transformValuesToCreateSLOInput;
exports.transformValuesToUpdateSLOInput = transformValuesToUpdateSLOInput;
var _omit = _interopRequireDefault(require("lodash/omit"));
var _duration = require("../../../utils/slo/duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformSloResponseToCreateSloInput(values) {
  if (!values) return undefined;
  return {
    ...(0, _omit.default)(values, ['id', 'revision', 'createdAt', 'updatedAt', 'summary', 'enabled']),
    objective: {
      target: values.objective.target * 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget * 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: String((0, _duration.toDuration)(values.objective.timesliceWindow).value)
      })
    }
  };
}
function transformValuesToCreateSLOInput(values) {
  return {
    ...values,
    objective: {
      target: values.objective.target / 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget / 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: `${values.objective.timesliceWindow}m`
      })
    }
  };
}
function transformValuesToUpdateSLOInput(values) {
  return {
    ...values,
    objective: {
      target: values.objective.target / 100,
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceTarget && {
        timesliceTarget: values.objective.timesliceTarget / 100
      }),
      ...(values.budgetingMethod === 'timeslices' && values.objective.timesliceWindow && {
        timesliceWindow: `${values.objective.timesliceWindow}m`
      })
    }
  };
}