"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMEWINDOW_OPTIONS = exports.SLO_EDIT_FORM_DEFAULT_VALUES = exports.SLI_OPTIONS = exports.BUDGETING_METHOD_OPTIONS = void 0;
var _i18n = require("@kbn/i18n");
var _labels = require("../../utils/slo/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLI_OPTIONS = [{
  value: 'sli.kql.custom',
  text: _labels.INDICATOR_CUSTOM_KQL
}, {
  value: 'sli.apm.transactionDuration',
  text: _labels.INDICATOR_APM_LATENCY
}, {
  value: 'sli.apm.transactionErrorRate',
  text: _labels.INDICATOR_APM_AVAILABILITY
}];
exports.SLI_OPTIONS = SLI_OPTIONS;
const BUDGETING_METHOD_OPTIONS = [{
  value: 'occurrences',
  text: _labels.BUDGETING_METHOD_OCCURRENCES
}, {
  value: 'timeslices',
  text: _labels.BUDGETING_METHOD_TIMESLICES
}];
exports.BUDGETING_METHOD_OPTIONS = BUDGETING_METHOD_OPTIONS;
const TIMEWINDOW_OPTIONS = [90, 30, 7].map(number => ({
  value: `${number}d`,
  text: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timeWindow.days', {
    defaultMessage: '{number} days',
    values: {
      number
    }
  })
}));
exports.TIMEWINDOW_OPTIONS = TIMEWINDOW_OPTIONS;
const SLO_EDIT_FORM_DEFAULT_VALUES = {
  name: '',
  description: '',
  indicator: {
    type: 'sli.kql.custom',
    params: {
      index: '',
      filter: '',
      good: '',
      total: '',
      timestampField: ''
    }
  },
  timeWindow: {
    duration: TIMEWINDOW_OPTIONS[TIMEWINDOW_OPTIONS.findIndex(option => option.value === '30d')].value,
    isRolling: true
  },
  tags: [],
  budgetingMethod: BUDGETING_METHOD_OPTIONS[0].value,
  objective: {
    target: 99
  }
};
exports.SLO_EDIT_FORM_DEFAULT_VALUES = SLO_EDIT_FORM_DEFAULT_VALUES;