"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditFormObjectiveSectionTimeslices = SloEditFormObjectiveSectionTimeslices;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloEditFormObjectiveSectionTimeslices() {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: getFieldState('objective.timesliceTarget').invalid,
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.timeSliceTarget.label', {
      defaultMessage: 'Timeslice target (%)'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timeSliceTarget.tooltip', {
        defaultMessage: 'The individual time slices target used to determine whether the slice is good or bad.'
      }),
      position: "top"
    }))
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "objective.timesliceTarget",
    control: control,
    defaultValue: 95,
    rules: {
      required: true,
      min: 0.001,
      max: 99.999
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      required: true,
      isInvalid: fieldState.invalid,
      value: String(field.value),
      "data-test-subj": "sloFormObjectiveTimesliceTargetInput",
      min: 0.001,
      max: 99.999,
      step: 0.001,
      onChange: event => field.onChange(Number(event.target.value))
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: getFieldState('objective.timesliceWindow').invalid,
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceWindow.label', {
      defaultMessage: 'Timeslice window (in minutes)'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timesliceWindow.tooltip', {
        defaultMessage: 'The time slice window size used to evaluate the data from.'
      }),
      position: "top"
    }))
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "objective.timesliceWindow",
    defaultValue: "1",
    control: control,
    rules: {
      required: true,
      min: 1,
      max: 120
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      isInvalid: fieldState.invalid,
      required: true,
      "data-test-subj": "sloFormObjectiveTimesliceWindowInput",
      value: String(field.value),
      min: 1,
      max: 120,
      step: 1,
      onChange: event => field.onChange(String(Number(event.target.value)))
    }))
  }))));
}