"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditFormObjectiveSection = SloEditFormObjectiveSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _slo_edit_form_objective_section_timeslices = require("./slo_edit_form_objective_section_timeslices");
var _constants = require("../constants");
var _slo_edit_form = require("./slo_edit_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloEditFormObjectiveSection() {
  const {
    control,
    watch,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const budgetingSelect = (0, _eui.useGeneratedHtmlId)({
    prefix: 'budgetingSelect'
  });
  const timeWindowSelect = (0, _eui.useGeneratedHtmlId)({
    prefix: 'timeWindowSelect'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    style: {
      maxWidth: _slo_edit_form.maxWidth
    },
    "data-test-subj": "sloEditFormObjectiveSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.budgetingMethod.label', {
      defaultMessage: 'Budgeting method'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.budgetingMethod.tooltip', {
        defaultMessage: 'Occurrences-based SLO uses the ratio of good events over the total events during the time window. Timeslices-based SLO uses the ratio of good time slices over the total time slices during the time window.'
      }),
      position: "top"
    }))
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "budgetingMethod",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, field, {
      required: true,
      id: budgetingSelect,
      "data-test-subj": "sloFormBudgetingMethodSelect",
      options: _constants.BUDGETING_METHOD_OPTIONS
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.timeWindow.label', {
      defaultMessage: 'Time window'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.timeWindow.tooltip', {
        defaultMessage: 'The rolling time window duration used to compute the SLO over.'
      }),
      position: "top"
    }))
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "timeWindow.duration",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, field, {
      required: true,
      id: timeWindowSelect,
      "data-test-subj": "sloFormTimeWindowDurationSelect",
      options: _constants.TIMEWINDOW_OPTIONS,
      value: String(field.value)
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: getFieldState('objective.target').invalid,
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.targetSlo.label', {
      defaultMessage: 'Target / SLO (%)'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability.slo.sloEdit.targetSlo.tooltip', {
        defaultMessage: 'The target objective in percentage for the SLO.'
      }),
      position: "top"
    }))
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "objective.target",
    control: control,
    rules: {
      required: true,
      min: 0.001,
      max: 99.999
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      required: true,
      isInvalid: fieldState.invalid,
      "data-test-subj": "sloFormObjectiveTargetInput",
      value: String(field.value),
      min: 0.001,
      max: 99.999,
      step: 0.001,
      onChange: event => field.onChange(Number(event.target.value))
    }))
  })))), watch('budgetingMethod') === 'timeslices' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_slo_edit_form_objective_section_timeslices.SloEditFormObjectiveSectionTimeslices, null)) : null);
}