"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditFormIndicatorSection = SloEditFormIndicatorSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _constants = require("../constants");
var _apm_availability_indicator_type_form = require("./apm_availability/apm_availability_indicator_type_form");
var _apm_latency_indicator_type_form = require("./apm_latency/apm_latency_indicator_type_form");
var _custom_kql_indicator_type_form = require("./custom_kql/custom_kql_indicator_type_form");
var _slo_edit_form = require("./slo_edit_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloEditFormIndicatorSection() {
  const {
    control,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const getIndicatorTypeForm = () => {
    switch (watch('indicator.type')) {
      case 'sli.kql.custom':
        return /*#__PURE__*/_react.default.createElement(_custom_kql_indicator_type_form.CustomKqlIndicatorTypeForm, null);
      case 'sli.apm.transactionDuration':
        return /*#__PURE__*/_react.default.createElement(_apm_latency_indicator_type_form.ApmLatencyIndicatorTypeForm, null);
      case 'sli.apm.transactionErrorRate':
        return /*#__PURE__*/_react.default.createElement(_apm_availability_indicator_type_form.ApmAvailabilityIndicatorTypeForm, null);
      default:
        return null;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    style: {
      maxWidth: _slo_edit_form.maxWidth
    },
    "data-test-subj": "sloEditFormIndicatorSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.definition.sliType', {
      defaultMessage: 'Choose the SLI type'
    })
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "indicator.type",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, field, {
      required: true,
      "data-test-subj": "sloFormIndicatorTypeSelect",
      options: _constants.SLI_OPTIONS
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), getIndicatorTypeForm());
}