"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditForm = SloEditForm;
exports.maxWidth = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _kibana_react = require("../../../utils/kibana_react");
var _use_create_slo = require("../../../hooks/slo/use_create_slo");
var _use_update_slo = require("../../../hooks/slo/use_update_slo");
var _use_show_sections = require("../hooks/use_show_sections");
var _use_fetch_rules_for_slo = require("../../../hooks/slo/use_fetch_rules_for_slo");
var _use_section_form_validation = require("../helpers/use_section_form_validation");
var _slo_edit_form_description_section = require("./slo_edit_form_description_section");
var _slo_edit_form_objective_section = require("./slo_edit_form_objective_section");
var _slo_edit_form_indicator_section = require("./slo_edit_form_indicator_section");
var _process_slo_form_values = require("../helpers/process_slo_form_values");
var _paths = require("../../../config/paths");
var _constants = require("../../../../common/constants");
var _constants2 = require("../constants");
var _common = require("../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maxWidth = 775;
exports.maxWidth = maxWidth;
const CREATE_RULE_SEARCH_PARAM = 'create-rule';
function SloEditForm({
  slo
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    triggersActionsUi: {
      getAddRuleFlyout: AddRuleFlyout
    }
  } = (0, _kibana_react.useKibana)().services;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    data: rules,
    isInitialLoading
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: slo !== null && slo !== void 0 && slo.id ? [slo.id] : undefined
  });
  const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false
  });
  const urlParams = urlStateStorage.get('_a');
  const searchParams = new URLSearchParams(search);
  const isEditMode = slo !== undefined;
  const [isAddRuleFlyoutOpen, setIsAddRuleFlyoutOpen] = (0, _react.useState)(false);
  const [isCreateRuleCheckboxChecked, setIsCreateRuleCheckboxChecked] = (0, _react.useState)(true);
  if (searchParams.has(CREATE_RULE_SEARCH_PARAM) && isEditMode && !isAddRuleFlyoutOpen) {
    setIsAddRuleFlyoutOpen(true);
  }
  (0, _react.useEffect)(() => {
    if (isEditMode && rules && rules[slo.id].length) {
      setIsCreateRuleCheckboxChecked(false);
    }
  }, [isEditMode, rules, slo]);
  const methods = (0, _reactHookForm.useForm)({
    defaultValues: {
      ..._constants2.SLO_EDIT_FORM_DEFAULT_VALUES,
      ...urlParams
    },
    values: (0, _process_slo_form_values.transformSloResponseToCreateSloInput)(slo),
    mode: 'all'
  });
  const {
    watch,
    getFieldState,
    getValues,
    formState,
    trigger
  } = methods;
  const {
    isIndicatorSectionValid,
    isObjectiveSectionValid,
    isDescriptionSectionValid
  } = (0, _use_section_form_validation.useSectionFormValidation)({
    getFieldState,
    getValues,
    formState,
    watch
  });
  const {
    showDescriptionSection,
    showObjectiveSection
  } = (0, _use_show_sections.useShowSections)(isEditMode, formState.isValidating, isIndicatorSectionValid, isObjectiveSectionValid);
  const {
    mutateAsync: createSlo,
    isLoading: isCreateSloLoading
  } = (0, _use_create_slo.useCreateSlo)();
  const {
    mutateAsync: updateSlo,
    isLoading: isUpdateSloLoading
  } = (0, _use_update_slo.useUpdateSlo)();
  const handleSubmit = async () => {
    const isValid = await trigger();
    if (!isValid) {
      return;
    }
    const values = getValues();
    if (isEditMode) {
      const processedValues = (0, _process_slo_form_values.transformValuesToUpdateSLOInput)(values);
      if (isCreateRuleCheckboxChecked) {
        await updateSlo({
          sloId: slo.id,
          slo: processedValues
        });
        navigate(basePath.prepend(`${_paths.paths.observability.sloEdit(slo.id)}?${CREATE_RULE_SEARCH_PARAM}=true`));
      } else {
        updateSlo({
          sloId: slo.id,
          slo: processedValues
        });
        navigate(basePath.prepend(_paths.paths.observability.slos));
      }
    } else {
      const processedValues = (0, _process_slo_form_values.transformValuesToCreateSLOInput)(values);
      if (isCreateRuleCheckboxChecked) {
        const {
          id
        } = await createSlo({
          slo: processedValues
        });
        navigate(basePath.prepend(`${_paths.paths.observability.sloEdit(id)}?${CREATE_RULE_SEARCH_PARAM}=true`));
      } else {
        createSlo({
          slo: processedValues
        });
        navigate(basePath.prepend(_paths.paths.observability.slos));
      }
    }
  };
  const navigate = (0, _react.useCallback)(url => setTimeout(() => navigateToUrl(url)), [navigateToUrl]);
  const handleChangeCheckbox = () => {
    setIsCreateRuleCheckboxChecked(!isCreateRuleCheckboxChecked);
  };
  const handleCloseRuleFlyout = async () => {
    navigateToUrl(basePath.prepend(_paths.paths.observability.slos));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, methods, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "sloForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.definition.title', {
        defaultMessage: 'Define SLI'
      }),
      children: /*#__PURE__*/_react.default.createElement(_slo_edit_form_indicator_section.SloEditFormIndicatorSection, null),
      status: isIndicatorSectionValid ? 'complete' : 'incomplete'
    }, {
      title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.objectives.title', {
        defaultMessage: 'Set objectives'
      }),
      children: showObjectiveSection ? /*#__PURE__*/_react.default.createElement(_slo_edit_form_objective_section.SloEditFormObjectiveSection, null) : null,
      status: showObjectiveSection && isObjectiveSectionValid ? 'complete' : 'incomplete'
    }, {
      title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.description.title', {
        defaultMessage: 'Describe SLO'
      }),
      children: showDescriptionSection ? /*#__PURE__*/_react.default.createElement(_slo_edit_form_description_section.SloEditFormDescriptionSection, null) : null,
      status: showDescriptionSection && isDescriptionSectionValid ? 'complete' : 'incomplete'
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "createNewRuleCheckbox",
    checked: isCreateRuleCheckboxChecked,
    disabled: isInitialLoading,
    "data-test-subj": "createNewRuleCheckbox",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.createAlert.title', {
      defaultMessage: 'Create an'
    }), ' ', /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.observability.slo.sloEdit.createAlert.ruleName', {
      defaultMessage: 'SLO burn rate alert rule'
    }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: 'Selecting this will allow you to create a new alert rule for this SLO upon saving.',
      position: "top"
    })),
    onChange: handleChangeCheckbox
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "sloFormSubmitButton",
    fill: true,
    isLoading: isCreateSloLoading || isUpdateSloLoading,
    onClick: handleSubmit
  }, isEditMode ? _i18n.i18n.translate('xpack.observability.slo.sloEdit.editSloButton', {
    defaultMessage: 'Update SLO'
  }) : _i18n.i18n.translate('xpack.observability.slo.sloEdit.createSloButton', {
    defaultMessage: 'Create SLO'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "ghost",
    "data-test-subj": "sloFormCancelButton",
    fill: true,
    disabled: isCreateSloLoading || isUpdateSloLoading,
    onClick: () => navigateToUrl(basePath.prepend(_paths.paths.observability.slos))
  }, _i18n.i18n.translate('xpack.observability.slo.sloEdit.cancelButton', {
    defaultMessage: 'Cancel'
  }))))), isAddRuleFlyoutOpen && slo ? /*#__PURE__*/_react.default.createElement(AddRuleFlyout, {
    canChangeTrigger: false,
    consumer: _common.sloFeatureId,
    initialValues: {
      name: `${slo.name} Burn Rate rule`,
      params: {
        sloId: slo.id
      }
    },
    ruleTypeId: _constants.SLO_BURN_RATE_RULE_ID,
    onClose: handleCloseRuleFlyout,
    onSave: handleCloseRuleFlyout
  }) : null);
}