"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSelection = IndexSelection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_fetch_indices = require("../../../../hooks/use_fetch_indices");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IndexSelection() {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const {
    isLoading,
    indices = []
  } = (0, _use_fetch_indices.useFetchIndices)();
  const [indexOptions, setIndexOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    setIndexOptions([createIndexOptions(indices)]);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [indices.length]);
  const onSearchChange = search => {
    const options = [];
    if (!search) {
      return setIndexOptions([createIndexOptions(indices)]);
    }
    const searchPattern = search.endsWith('*') ? search.substring(0, search.length - 1) : search;
    const matchingIndices = indices.filter(({
      name
    }) => name.startsWith(searchPattern));
    if (matchingIndices.length === 0) {
      return setIndexOptions([]);
    }
    options.push(createIndexOptions(matchingIndices));
    const searchWithStarSuffix = search.endsWith('*') ? search : `${search}*`;
    options.push({
      label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.indexPatternLabel', {
        defaultMessage: 'Use an index pattern'
      }),
      options: [{
        value: searchWithStarSuffix,
        label: searchWithStarSuffix
      }]
    });
    setIndexOptions(options);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.label', {
      defaultMessage: 'Index'
    }),
    helpText: _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.helpText', {
      defaultMessage: 'Use * to broaden your query.'
    }),
    isInvalid: getFieldState('indicator.params.index').invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    shouldUnregister: true,
    defaultValue: "",
    name: "indicator.params.index",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field,
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      "aria-label": _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.placeholder', {
        defaultMessage: 'Select an index or index pattern'
      }),
      async: true,
      "data-test-subj": "indexSelection",
      isClearable: true,
      isInvalid: fieldState.invalid,
      isLoading: isLoading,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      onSearchChange: onSearchChange,
      options: indexOptions,
      placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.placeholder', {
        defaultMessage: 'Select an index or index pattern'
      }),
      selectedOptions: !!field.value ? [{
        value: field.value,
        label: field.value,
        'data-test-subj': 'indexSelectionSelectedValue'
      }] : [],
      singleSelection: true
    }))
  }));
}
function createIndexOptions(indices) {
  return {
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.customKql.indexSelection.indexOptionsLabel', {
      defaultMessage: 'Select an existing index'
    }),
    options: indices.map(({
      name
    }) => ({
      label: name,
      value: name
    })).sort((a, b) => String(a.label).localeCompare(b.label))
  };
}