"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryBuilder = QueryBuilder;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _kibana_react = require("../../../../utils/kibana_react");
var _use_create_data_view = require("../../../../hooks/use_create_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function QueryBuilder({
  control,
  dataTestSubj,
  indexPatternString,
  label,
  name,
  placeholder,
  tooltip
}) {
  const {
    data,
    dataViews,
    docLinks,
    http,
    notifications,
    storage,
    uiSettings,
    unifiedSearch
  } = (0, _kibana_react.useKibana)().services;
  const {
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: !!tooltip ? /*#__PURE__*/_react.default.createElement("span", null, label, " ", tooltip) : label,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    shouldUnregister: true,
    defaultValue: "",
    name: name,
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
      appName: "Observability",
      bubbleSubmitEvent: false,
      dataTestSubj: dataTestSubj,
      deps: {
        data,
        dataViews,
        docLinks,
        http,
        notifications,
        storage,
        uiSettings,
        unifiedSearch
      },
      disableAutoFocus: true,
      disableLanguageSwitcher: true,
      indexPatterns: dataView ? [dataView] : [],
      isDisabled: !indexPatternString,
      languageSwitcherPopoverAnchorPosition: "rightDown",
      placeholder: placeholder,
      query: {
        query: String(field.value),
        language: 'kuery'
      },
      size: "s",
      onChange: value => {
        field.onChange(value.query);
      }
    })
  }));
}