"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelector = FieldSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _use_fetch_apm_suggestions = require("../../../../hooks/slo/use_fetch_apm_suggestions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldSelector({
  allowAllOption = true,
  dataTestSubj,
  fieldName,
  label,
  name,
  placeholder,
  tooltip
}) {
  const {
    control,
    watch,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const serviceName = watch('indicator.params.service');
  const [search, setSearch] = (0, _react.useState)('');
  const {
    suggestions,
    isLoading
  } = (0, _use_fetch_apm_suggestions.useFetchApmSuggestions)({
    fieldName,
    search,
    serviceName
  });
  const debouncedSearch = (0, _lodash.debounce)(value => setSearch(value), 200);
  const options = (allowAllOption ? [{
    value: '*',
    label: _i18n.i18n.translate('xpack.observability.slo.sloEdit.fieldSelector.all', {
      defaultMessage: 'All'
    })
  }] : []).concat(createOptions(suggestions));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: !!tooltip ? /*#__PURE__*/_react.default.createElement("span", null, label, " ", tooltip) : label,
    isInvalid: getFieldState(name).invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    shouldUnregister: true,
    defaultValue: "",
    name: name,
    control: control,
    rules: {
      required: true
    },
    render: ({
      field,
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      "aria-label": placeholder,
      async: true,
      "data-test-subj": dataTestSubj,
      isClearable: true,
      isDisabled: name !== 'indicator.params.service' && !serviceName,
      isInvalid: fieldState.invalid,
      isLoading: isLoading,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      onSearchChange: value => debouncedSearch(value),
      options: options,
      placeholder: placeholder,
      selectedOptions: !!field.value && typeof field.value === 'string' ? [{
        value: field.value,
        label: field.value,
        'data-test-subj': `${dataTestSubj}SelectedValue`
      }] : [],
      singleSelection: true
    }))
  })));
}
function createOptions(suggestions) {
  return suggestions.map(suggestion => ({
    label: suggestion,
    value: suggestion
  })).sort((a, b) => String(a.label).localeCompare(b.label));
}