"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDetails = SloDetails;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
var _use_fetch_active_alerts = require("../../../hooks/slo/use_fetch_active_alerts");
var _kibana_react = require("../../../utils/kibana_react");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _use_fetch_historical_summary = require("../../../hooks/slo/use_fetch_historical_summary");
var _error_budget_chart_panel = require("./error_budget_chart_panel");
var _overview = require("./overview");
var _sli_chart_panel = require("./sli_chart_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_TABLE_ID = 'xpack.observability.slo.sloDetails.alertTable';
const OVERVIEW_TAB = 'overview';
const ALERTS_TAB = 'alerts';
function SloDetails({
  slo,
  isAutoRefreshing
}) {
  var _ref, _activeAlerts$slo$id;
  const {
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      getAlertsStateTable: AlertsStateTable
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    data: activeAlerts
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIds: [slo.id]
  });
  const {
    isLoading: historicalSummaryLoading,
    sloHistoricalSummaryResponse = {}
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloIds: [slo.id],
    shouldRefetch: isAutoRefreshing
  });
  const errorBudgetBurnDownData = (0, _chart_data_formatter.formatHistoricalData)(sloHistoricalSummaryResponse[slo.id], 'error_budget_remaining');
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(sloHistoricalSummaryResponse[slo.id], 'sli_value');
  const tabs = [{
    id: OVERVIEW_TAB,
    name: _i18n.i18n.translate('xpack.observability.slo.sloDetails.tab.overviewLabel', {
      defaultMessage: 'Overview'
    }),
    'data-test-subj': 'overviewTab',
    content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview.Overview, {
      slo: slo
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_sli_chart_panel.SliChartPanel, {
      data: historicalSliData,
      isLoading: historicalSummaryLoading,
      slo: slo
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_error_budget_chart_panel.ErrorBudgetChartPanel, {
      data: errorBudgetBurnDownData,
      isLoading: historicalSummaryLoading,
      slo: slo
    })))))
  }, {
    id: ALERTS_TAB,
    name: _i18n.i18n.translate('xpack.observability.slo.sloDetails.tab.alertsLabel', {
      defaultMessage: 'Alerts'
    }),
    'data-test-subj': 'alertsTab',
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      className: "eui-alignCenter",
      size: "m"
    }, (_ref = activeAlerts && ((_activeAlerts$slo$id = activeAlerts[slo.id]) === null || _activeAlerts$slo$id === void 0 ? void 0 : _activeAlerts$slo$id.count)) !== null && _ref !== void 0 ? _ref : 0),
    content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
      alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
      configurationId: _ruleDataUtils.AlertConsumers.OBSERVABILITY,
      id: ALERTS_TABLE_ID,
      flyoutSize: "s",
      "data-test-subj": "alertTable",
      featureIds: [_ruleDataUtils.AlertConsumers.SLO],
      query: {
        bool: {
          filter: {
            term: {
              'slo.id': slo.id
            }
          }
        }
      },
      showExpandToDetails: false,
      showAlertStatusWithFlapping: true,
      pageSize: 100
    }))))
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "sloDetailsTabbedContent",
    tabs: tabs,
    initialSelectedTab: tabs[0]
  });
}