"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SliChartPanel = SliChartPanel;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _kibana_react = require("../../../utils/kibana_react");
var _labels = require("../../../utils/slo/labels");
var _wide_chart = require("./wide_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SliChartPanel({
  data,
  isLoading,
  slo
}) {
  const {
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const isSloFailed = slo.summary.status === 'DEGRADING' || slo.summary.status === 'VIOLATED';
  const hasNoData = slo.summary.status === 'NO_DATA';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "sliChartPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.slo.sloDetails.sliHistoryChartPanel.title', {
    defaultMessage: 'Historical SLI'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.slo.sloDetails.sliHistoryChartPanel.duration', {
    defaultMessage: 'Last {duration}',
    values: {
      duration: (0, _labels.toDurationLabel)(slo.timeWindow.duration)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l",
    alignItems: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleColor: isSloFailed ? 'danger' : 'success',
    title: hasNoData ? '-' : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.observability.slo.sloDetails.sliHistoryChartPanel.current', {
      defaultMessage: 'Observed value'
    }),
    reverse: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _numeral.default)(slo.objective.target).format(percentFormat),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.observability.slo.sloDetails.sliHistoryChartPanel.objective', {
      defaultMessage: 'Objective'
    }),
    reverse: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_wide_chart.WideChart, {
    chart: "line",
    id: _i18n.i18n.translate('xpack.observability.slo.sloDetails.sliHistoryChartPanel.chartTitle', {
      defaultMessage: 'SLI value'
    }),
    state: isSloFailed ? 'error' : 'success',
    data: data,
    isLoading: isLoading
  }))));
}