"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = Overview;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _labels = require("../../../utils/slo/labels");
var _kibana_react = require("../../../utils/kibana_react");
var _overview_item = require("./overview_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Overview({
  slo
}) {
  const {
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const dateFormat = uiSettings.get('dateFormat');
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const hasNoData = slo.summary.status === 'NO_DATA';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    color: "transparent",
    "data-test-subj": "overview"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.observedValueTitle', {
      defaultMessage: 'Observed value'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.observedValueSubtitle', {
      defaultMessage: '{value} (objective is {objective})',
      values: {
        value: hasNoData ? '-' : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat),
        objective: (0, _numeral.default)(slo.objective.target).format(percentFormat)
      }
    }))
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.indicatorTypeTitle', {
      defaultMessage: 'Indicator type'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _labels.toIndicatorTypeLabel)(slo.indicator.type))
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.timeWindowTitle', {
      defaultMessage: 'Time window'
    }),
    subtitle: toTimeWindowLabel(slo.timeWindow)
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.budgetingMethodTitle', {
      defaultMessage: 'Budgeting method'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _labels.toBudgetingMethodLabel)(slo.budgetingMethod))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.descriptionTitle', {
      defaultMessage: 'Description'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, !!slo.description ? slo.description : '-')
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.createdAtTitle', {
      defaultMessage: 'Created at'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _moment.default)(slo.createdAt).format(dateFormat))
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.updatedAtTitle', {
      defaultMessage: 'Last update at'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _moment.default)(slo.updatedAt).format(dateFormat))
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.tagsTitle', {
      defaultMessage: 'Tags'
    }),
    subtitle: slo.tags.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "flexStart",
      gutterSize: "s",
      responsive: false
    }, slo.tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: tag
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, tag)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, "-")
  }))));
}
function toTimeWindowLabel(timeWindow) {
  if ('isRolling' in timeWindow) {
    return _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.rollingTimeWindow', {
      defaultMessage: '{duration} rolling',
      values: {
        duration: (0, _labels.toDurationLabel)(timeWindow.duration)
      }
    });
  }
  return _i18n.i18n.translate('xpack.observability.slo.sloDetails.overview.calendarAlignedTimeWindow', {
    defaultMessage: '{duration}',
    values: {
      duration: timeWindow.duration
    }
  });
}