"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesPage = RulesPage;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _common = require("@kbn/alerting-plugin/common");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _use_get_filtered_rule_types = require("../../hooks/use_get_filtered_rule_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RulesPage() {
  const {
    http,
    docLinks,
    triggersActionsUi: {
      getAddRuleFlyout: AddRuleFlyout,
      getRulesList: RuleList,
      getRulesSettingsLink: RulesSettingsLink
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const history = (0, _reactRouterDom.useHistory)();
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    href: http.basePath.prepend('/app/observability/alerts')
  }, {
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.rulesLinkText', {
      defaultMessage: 'Rules'
    })
  }]);
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    ruleTypes
  } = (0, _public.useLoadRuleTypes)({
    filteredRuleTypes
  });
  const authorizedRuleTypes = [...ruleTypes.values()];
  const authorizedToCreateAnyRules = authorizedRuleTypes.some(ruleType => {
    var _ruleType$authorizedC;
    return (_ruleType$authorizedC = ruleType.authorizedConsumers[_common.ALERTS_FEATURE_ID]) === null || _ruleType$authorizedC === void 0 ? void 0 : _ruleType$authorizedC.all;
  });
  const urlStateStorage = (0, _public2.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false
  });
  const {
    lastResponse,
    params,
    search,
    status,
    type
  } = urlStateStorage.get('_a') || {
    lastResponse: [],
    params: {},
    search: '',
    status: [],
    type: []
  };
  const [stateLastResponse, setLastResponse] = (0, _react.useState)(lastResponse);
  const [stateParams, setParams] = (0, _react.useState)(params);
  const [stateSearch, setSearch] = (0, _react.useState)(search);
  const [stateStatus, setStatus] = (0, _react.useState)(status);
  const [stateType, setType] = (0, _react.useState)(type);
  const [stateRefresh, setRefresh] = (0, _react.useState)(new Date());
  const [addRuleFlyoutVisibility, setAddRuleFlyoutVisibility] = (0, _react.useState)(false);
  const handleStatusFilterChange = newStatus => {
    setStatus(newStatus);
    urlStateStorage.set('_a', {
      lastResponse,
      params,
      search,
      status: newStatus,
      type
    });
  };
  const handleLastRunOutcomeFilterChange = newLastResponse => {
    setRefresh(new Date());
    setLastResponse(newLastResponse);
    urlStateStorage.set('_a', {
      lastResponse: newLastResponse,
      params,
      search,
      status,
      type
    });
  };
  const handleTypeFilterChange = newType => {
    setType(newType);
    urlStateStorage.set('_a', {
      lastResponse,
      params,
      search,
      status,
      type: newType
    });
  };
  const handleSearchFilterChange = newSearch => {
    setSearch(newSearch);
    urlStateStorage.set('_a', {
      lastResponse,
      params,
      search: newSearch,
      status,
      type
    });
  };
  const handleRuleParamFilterChange = newParams => {
    setParams(newParams);
    urlStateStorage.set('_a', {
      lastResponse,
      params: newParams,
      search,
      status,
      type
    });
  };
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.observability.rulesTitle', {
        defaultMessage: 'Rules'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "createRuleButton",
        disabled: !authorizedToCreateAnyRules,
        fill: true,
        iconType: "plusInCircle",
        key: "create-alert",
        onClick: () => setAddRuleFlyoutVisibility(true)
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.rules.addRuleButtonLabel",
        defaultMessage: "Create rule"
      })), /*#__PURE__*/_react.default.createElement(RulesSettingsLink, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "documentationLink",
        href: docLinks.links.observability.createAlerts,
        iconType: "help",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.rules.docsLinkText",
        defaultMessage: "Documentation"
      }))]
    },
    "data-test-subj": "rulesPage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(RuleList, {
    filteredRuleTypes: filteredRuleTypes,
    lastRunOutcomeFilter: stateLastResponse,
    refresh: stateRefresh,
    ruleDetailsRoute: "alerts/rules/:ruleId",
    rulesListKey: "observability_rulesListColumns",
    ruleParamFilter: stateParams,
    showActionFilter: false,
    statusFilter: stateStatus,
    searchFilter: stateSearch,
    typeFilter: stateType,
    visibleColumns: ['ruleName', 'ruleExecutionStatusLastDate', 'ruleSnoozeNotify', 'ruleExecutionStatus', 'ruleExecutionState'],
    onLastRunOutcomeFilterChange: handleLastRunOutcomeFilterChange,
    onRuleParamFilterChange: handleRuleParamFilterChange,
    onSearchFilterChange: handleSearchFilterChange,
    onStatusFilterChange: handleStatusFilterChange,
    onTypeFilterChange: handleTypeFilterChange
  }))), addRuleFlyoutVisibility && /*#__PURE__*/_react.default.createElement(AddRuleFlyout, {
    consumer: _common.ALERTS_FEATURE_ID,
    filteredRuleTypes: filteredRuleTypes,
    onClose: () => {
      setAddRuleFlyoutVisibility(false);
    },
    onSave: () => {
      setRefresh(new Date());
      return Promise.resolve();
    }
  }));
}