"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsPage = RuleDetailsPage;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _common = require("@kbn/alerting-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _url = require("../../utils/url");
var _alert_summary_widget = require("../../utils/alert_summary_widget");
var _alert_search_bar = require("../../components/shared/alert_search_bar");
var _delete_modal_confirmation = require("./components/delete_modal_confirmation");
var _center_justified_spinner = require("../../components/center_justified_spinner");
var _constants = require("./constants");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_fetch_rule = require("../../hooks/use_fetch_rule");
var _components = require("./components");
var _config = require("./config");
var _paths = require("../../config/paths");
var _constants2 = require("../../../common/constants");
var _common2 = require("../../../common");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: use a Delete modal from triggersActionUI when it's sharable

function RuleDetailsPage() {
  var _rule$executionStatus;
  const {
    charts,
    http,
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      ruleTypeRegistry,
      getEditRuleFlyout: EditRuleFlyout,
      getRuleEventLogList,
      getAlertsStateTable: AlertsStateTable,
      getAlertSummaryWidget: AlertSummaryWidget,
      getRuleStatusPanel: RuleStatusPanel,
      getRuleDefinition
    },
    application: {
      capabilities,
      navigateToUrl
    },
    notifications: {
      toasts
    },
    share: {
      url: {
        locators
      }
    }
  } = (0, _public2.useKibana)().services;
  const {
    ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    ObservabilityPageTemplate,
    observabilityRuleTypeRegistry
  } = (0, _use_plugin_context.usePluginContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const chartProps = {
    theme: charts.theme.useChartsTheme(),
    baseTheme: charts.theme.useChartsBaseTheme()
  };
  const filteredRuleTypes = (0, _react.useMemo)(() => observabilityRuleTypeRegistry.list(), [observabilityRuleTypeRegistry]);
  const {
    isRuleLoading,
    rule,
    errorRule,
    reloadRule
  } = (0, _use_fetch_rule.useFetchRule)({
    ruleId,
    http
  });
  const {
    ruleTypes
  } = (0, _public.useLoadRuleTypes)({
    filteredRuleTypes
  });
  const [tabId, setTabId] = (0, _react.useState)(() => {
    var _toQuery;
    const urlTabId = ((_toQuery = (0, _url.toQuery)(location.search)) === null || _toQuery === void 0 ? void 0 : _toQuery.tabId) || _constants.EXECUTION_TAB;
    return [_constants.EXECUTION_TAB, _constants.ALERTS_TAB].includes(urlTabId) ? urlTabId : _constants.EXECUTION_TAB;
  });
  const [featureIds, setFeatureIds] = (0, _react.useState)();
  const [ruleType, setRuleType] = (0, _react.useState)();
  const [ruleToDelete, setRuleToDelete] = (0, _react.useState)([]);
  const [isPageLoading, setIsPageLoading] = (0, _react.useState)(false);
  const [editFlyoutVisible, setEditFlyoutVisible] = (0, _react.useState)(false);
  const [isRuleEditPopoverOpen, setIsRuleEditPopoverOpen] = (0, _react.useState)(false);
  const [esQuery, setEsQuery] = (0, _react.useState)();
  const [alertSummaryWidgetTimeRange, setAlertSummaryWidgetTimeRange] = (0, _react.useState)(_alert_summary_widget.getDefaultAlertSummaryTimeRange);
  const ruleQuery = (0, _react.useRef)([{
    query: `kibana.alert.rule.uuid: ${ruleId}`,
    language: 'kuery'
  }]);
  const alertSummaryWidgetFilter = (0, _react.useRef)({
    term: {
      'kibana.alert.rule.uuid': ruleId
    }
  });
  const tabsRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    setAlertSummaryWidgetTimeRange((0, _alert_summary_widget.getDefaultAlertSummaryTimeRange)());
  }, [esQuery]);
  const onAlertSummaryWidgetClick = async (status = _constants2.ALERT_STATUS_ALL) => {
    var _locators$get, _tabsRef$current;
    setAlertSummaryWidgetTimeRange((0, _alert_summary_widget.getDefaultAlertSummaryTimeRange)());
    await ((_locators$get = locators.get(_common2.ruleDetailsLocatorID)) === null || _locators$get === void 0 ? void 0 : _locators$get.navigate({
      rangeFrom: _alert_summary_widget.defaultTimeRange.from,
      rangeTo: _alert_summary_widget.defaultTimeRange.to,
      ruleId,
      status,
      tabId: _constants.ALERTS_TAB
    }, {
      replace: true
    }));
    setTabId(_constants.ALERTS_TAB);
    (_tabsRef$current = tabsRef.current) === null || _tabsRef$current === void 0 ? void 0 : _tabsRef$current.scrollIntoView({
      behavior: 'smooth'
    });
  };
  const updateUrl = nextQuery => {
    const newTabId = nextQuery.tabId;
    const nextSearch = newTabId === _constants.ALERTS_TAB ? {
      ...(0, _url.toQuery)(location.search),
      ...nextQuery
    } : {
      tabId: _constants.EXECUTION_TAB
    };
    history.replace({
      ...location,
      search: (0, _url.fromQuery)(nextSearch)
    });
  };
  const onTabIdChange = newTabId => {
    setTabId(newTabId);
    updateUrl({
      tabId: newTabId
    });
  };
  const NOTIFY_WHEN_OPTIONS = (0, _react.useRef)([]);
  (0, _react.useEffect)(() => {
    const loadNotifyWhenOption = async () => {
      NOTIFY_WHEN_OPTIONS.current = await (0, _public.getNotifyWhenOptions)();
    };
    loadNotifyWhenOption();
  }, []);
  const togglePopover = () => setIsRuleEditPopoverOpen(pervIsRuleEditPopoverOpen => !pervIsRuleEditPopoverOpen);
  const handleClosePopover = () => setIsRuleEditPopoverOpen(false);
  const handleRemoveRule = (0, _react.useCallback)(() => {
    setIsRuleEditPopoverOpen(false);
    if (rule) setRuleToDelete([rule.id]);
  }, [rule]);
  const handleEditRule = (0, _react.useCallback)(() => {
    setIsRuleEditPopoverOpen(false);
    setEditFlyoutVisible(true);
  }, []);
  (0, _react.useEffect)(() => {
    if (ruleTypes.length && rule) {
      const matchedRuleType = ruleTypes.find(type => type.id === rule.ruleTypeId);
      setRuleType(matchedRuleType);
      if (rule.consumer === _common.ALERTS_FEATURE_ID && matchedRuleType && matchedRuleType.producer) {
        setFeatureIds([matchedRuleType.producer]);
      } else setFeatureIds([rule.consumer]);
    }
  }, [rule, ruleTypes]);
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    href: http.basePath.prepend(_paths.paths.observability.alerts)
  }, {
    href: http.basePath.prepend(_paths.paths.observability.rules),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.rulesLinkText', {
      defaultMessage: 'Rules'
    })
  }, {
    text: rule && rule.name
  }]);
  const canExecuteActions = (0, _config.hasExecuteActionsCapability)(capabilities);
  const canSaveRule = rule && (0, _config.hasAllPrivilege)(rule, ruleType) && (
  // if the rule has actions, can the user save the rule's action params
  canExecuteActions || !canExecuteActions && rule.actions.length === 0);
  const hasEditButton =
  // can the user save the rule
  canSaveRule && (
  // is this rule type editable from within Rules Management
  ruleTypeRegistry.has(rule.ruleTypeId) ? !ruleTypeRegistry.get(rule.ruleTypeId).requiresAppContext : false);
  const tabs = [{
    id: _constants.EXECUTION_TAB,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.rule.eventLogTabText', {
      defaultMessage: 'Execution history'
    }),
    'data-test-subj': 'eventLogListTab',
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        minHeight: 600
      },
      direction: 'column'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, getRuleEventLogList({
      ruleId: rule === null || rule === void 0 ? void 0 : rule.id,
      ruleType
    })))
  }, {
    id: _constants.ALERTS_TAB,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.rule.alertsTabText', {
      defaultMessage: 'Alerts'
    }),
    'data-test-subj': 'ruleAlertListTab',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_alert_search_bar.ObservabilityAlertSearchbarWithUrlSync, {
      appName: _constants.RULE_DETAILS_ALERTS_SEARCH_BAR_ID,
      onEsQueryChange: setEsQuery,
      urlStorageKey: _constants.SEARCH_BAR_URL_STORAGE_KEY,
      defaultSearchQueries: ruleQuery.current
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        minHeight: 450
      },
      direction: 'column'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, esQuery && featureIds && /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
      alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
      configurationId: _common2.observabilityFeatureId,
      id: _constants.RULE_DETAILS_PAGE_ID,
      flyoutSize: 's',
      featureIds: featureIds,
      query: esQuery,
      showExpandToDetails: false,
      showAlertStatusWithFlapping: true
    }))))
  }];
  if (isPageLoading || isRuleLoading) return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
  if (!rule || errorRule) return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.ruleDetails.errorPromptTitle', {
      defaultMessage: 'Unable to load rule details'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability.ruleDetails.errorPromptBody', {
      defaultMessage: 'There was an error loading the rule details.'
    }))
  }));
  const isLicenseError = ((_rule$executionStatus = rule.executionStatus.error) === null || _rule$executionStatus === void 0 ? void 0 : _rule$executionStatus.reason) === _common.RuleExecutionStatusErrorReasons.License;
  const statusMessage = isLicenseError ? _translations.ALERT_STATUS_LICENSE_ERROR : _translations.rulesStatusesTranslationsMapping[rule.executionStatus.status];
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "ruleDetails",
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_components.PageTitle, {
        rule: rule
      }),
      bottomBorder: false,
      rightSideItems: hasEditButton ? [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "rowReverse",
        alignItems: "flexStart"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        id: "contextRuleEditMenu",
        isOpen: isRuleEditPopoverOpen,
        closePopover: handleClosePopover,
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          fill: true,
          iconSide: "right",
          onClick: togglePopover,
          iconType: "arrowDown",
          "data-test-subj": "actions"
        }, _i18n.i18n.translate('xpack.observability.ruleDetails.actionsButtonLabel', {
          defaultMessage: 'Actions'
        }))
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        alignItems: "flexStart",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "editRuleButton",
        size: "s",
        iconType: "pencil",
        onClick: handleEditRule
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.observability.ruleDetails.editRule', {
        defaultMessage: 'Edit rule'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        iconType: "trash",
        color: "danger",
        onClick: handleRemoveRule,
        "data-test-subj": "deleteRuleButton"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.observability.ruleDetails.deleteRule', {
        defaultMessage: 'Delete rule'
      })))))))] : []
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 350
    }
  }, /*#__PURE__*/_react.default.createElement(RuleStatusPanel, {
    rule: rule,
    isEditable: hasEditButton,
    requestRefresh: reloadRule,
    healthColor: (0, _config.getHealthColor)(rule.executionStatus.status),
    statusMessage: statusMessage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 350
    }
  }, /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    chartProps: chartProps,
    featureIds: featureIds,
    onClick: onAlertSummaryWidgetClick,
    timeRange: alertSummaryWidgetTimeRange,
    filter: alertSummaryWidgetFilter.current
  })), getRuleDefinition({
    rule,
    onEditRule: reloadRule
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: tabsRef
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "ruleDetailsTabbedContent",
    tabs: tabs,
    selectedTab: tabs.find(tab => tab.id === tabId),
    onTabClick: tab => {
      onTabIdChange(tab.id);
    }
  }), editFlyoutVisible && /*#__PURE__*/_react.default.createElement(EditRuleFlyout, {
    initialRule: rule,
    onClose: () => {
      setEditFlyoutVisible(false);
    },
    onSave: reloadRule
  }), /*#__PURE__*/_react.default.createElement(_delete_modal_confirmation.DeleteModalConfirmation, {
    onDeleted: () => {
      setRuleToDelete([]);
      navigateToUrl(http.basePath.prepend(_paths.paths.observability.rules));
    },
    onErrors: () => {
      setRuleToDelete([]);
      navigateToUrl(http.basePath.prepend(_paths.paths.observability.rules));
    },
    onCancel: () => setRuleToDelete([]),
    apiDeleteCall: _public.bulkDeleteRules,
    idsToDelete: ruleToDelete,
    singleTitle: rule.name,
    multipleTitle: rule.name,
    setIsLoadingState: () => setIsPageLoading(true)
  }), errorRule && toasts.addDanger({
    title: errorRule
  }));
}