"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHealthColor = getHealthColor;
exports.hasAllPrivilege = hasAllPrivilege;
exports.hasExecuteActionsCapability = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getHealthColor(status) {
  switch (status) {
    case 'active':
      return 'success';
    case 'error':
      return 'danger';
    case 'ok':
      return 'primary';
    case 'pending':
      return 'accent';
    default:
      return 'subdued';
  }
}
function hasAllPrivilege(rule, ruleType) {
  var _ruleType$authorizedC, _ruleType$authorizedC2;
  return (_ruleType$authorizedC = ruleType === null || ruleType === void 0 ? void 0 : (_ruleType$authorizedC2 = ruleType.authorizedConsumers[rule.consumer]) === null || _ruleType$authorizedC2 === void 0 ? void 0 : _ruleType$authorizedC2.all) !== null && _ruleType$authorizedC !== void 0 ? _ruleType$authorizedC : false;
}
const hasExecuteActionsCapability = capabilities => {
  var _capabilities$actions;
  return capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$actions = capabilities.actions) === null || _capabilities$actions === void 0 ? void 0 : _capabilities$actions.execute;
};
exports.hasExecuteActionsCapability = hasExecuteActionsCapability;