"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageTitle = PageTitle;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _kibana_react = require("../../../utils/kibana_react");
var _translations = require("../translations");
var _config = require("../config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PageTitle({
  rule
}) {
  const {
    triggersActionsUi
  } = (0, _kibana_react.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "ruleName"
  }, rule.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (0, _config.getHealthColor)(rule.executionStatus.status)
  }, rule.executionStatus.status.charAt(0).toUpperCase() + rule.executionStatus.status.slice(1))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("b", null, _translations.LAST_UPDATED_MESSAGE), " ", _translations.BY_WORD, " ", rule.updatedBy, " ", _translations.ON_WORD, "\xA0", (0, _moment.default)(rule.updatedAt).format('ll'), " \u2003", /*#__PURE__*/_react.default.createElement("b", null, _translations.CREATED_WORD), " ", _translations.BY_WORD, " ", rule.createdBy, " ", _translations.ON_WORD, "\xA0", (0, _moment.default)(rule.createdAt).format('ll'))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), rule.tags.length > 0 && triggersActionsUi.getRuleTagBadge({
    tagsOutPopover: true,
    tags: rule.tags
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
}