"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewPage = OverviewPage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _loading_observability = require("../../components/loading_observability");
var _header_actions = require("./components/header_actions");
var _data_assistant_flyout = require("./components/data_assistant_flyout");
var _empty_sections = require("./components/empty_sections");
var _header_menu = require("./components/header_menu");
var _resources = require("./components/resources");
var _news_feed = require("./components/news_feed");
var _observability_status_progress = require("../../components/app/observability_status/observability_status_progress");
var _alert_feature_ids = require("../../config/alert_feature_ids");
var _paths = require("../../config/paths");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _use_date_picker_context = require("../../hooks/use_date_picker_context");
var _use_fetcher = require("../../hooks/use_fetcher");
var _use_guided_setup_progress = require("../../hooks/use_guided_setup_progress");
var _use_has_data = require("../../hooks/use_has_data");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_time_buckets = require("../../hooks/use_time_buckets");
var _get_news_feed = require("../../services/get_news_feed");
var _build_es_query = require("../../utils/build_es_query");
var _alert_summary_widget = require("../../utils/alert_summary_widget");
var _constants = require("../../constants");
var _calculate_bucket_size = require("./helpers/calculate_bucket_size");
var _use_overview_metrics = require("./helpers/use_overview_metrics");
var _section = require("../../components/app/section");
var _data_sections = require("./components/data_sections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_PER_PAGE = 10;
const ALERTS_TABLE_ID = 'xpack.observability.overview.alert.table';
function OverviewPage() {
  var _newsFeed$items;
  const {
    charts,
    http,
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      getAlertsStateTable: AlertsStateTable,
      getAlertSummaryWidget: AlertSummaryWidget
    },
    kibanaVersion
  } = (0, _public.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.overviewLinkText', {
      defaultMessage: 'Overview'
    })
  }]);
  const {
    data: newsFeed
  } = (0, _use_fetcher.useFetcher)(() => (0, _get_news_feed.getNewsFeed)({
    http,
    kibanaVersion
  }), [http, kibanaVersion]);
  const {
    hasAnyData,
    isAllRequestsComplete
  } = (0, _use_has_data.useHasData)();
  const {
    trackMetric
  } = (0, _use_overview_metrics.useOverviewMetrics)({
    hasAnyData
  });
  const [isDataAssistantFlyoutVisible, setIsDataAssistantFlyoutVisible] = (0, _react.useState)(false);
  const {
    isGuidedSetupProgressDismissed
  } = (0, _use_guided_setup_progress.useGuidedSetupProgress)();
  const [isGuidedSetupTourVisible, setGuidedSetupTourVisible] = (0, _react.useState)(false);
  const {
    relativeStart,
    relativeEnd,
    absoluteStart,
    absoluteEnd
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const [esQuery, setEsQuery] = (0, _react.useState)((0, _build_es_query.buildEsQuery)({
    from: relativeStart,
    to: relativeEnd
  }));
  const timeBuckets = (0, _use_time_buckets.useTimeBuckets)();
  const bucketSize = (0, _react.useMemo)(() => (0, _calculate_bucket_size.calculateBucketSize)({
    start: absoluteStart,
    end: absoluteEnd,
    timeBuckets
  }), [absoluteStart, absoluteEnd, timeBuckets]);
  const alertSummaryTimeRange = (0, _react.useMemo)(() => (0, _alert_summary_widget.getAlertSummaryTimeRange)({
    from: relativeStart,
    to: relativeEnd
  }, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.intervalString) || _constants.DEFAULT_INTERVAL, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) || _constants.DEFAULT_DATE_FORMAT), [bucketSize, relativeEnd, relativeStart]);
  const chartProps = {
    theme: charts.theme.useChartsTheme(),
    baseTheme: charts.theme.useChartsBaseTheme()
  };
  (0, _react.useEffect)(() => {
    setEsQuery((0, _build_es_query.buildEsQuery)({
      from: relativeStart,
      to: relativeEnd
    }));
  }, [relativeEnd, relativeStart]);
  const handleTimeRangeRefresh = (0, _react.useCallback)(() => {
    setEsQuery((0, _build_es_query.buildEsQuery)({
      from: relativeStart,
      to: relativeEnd
    }));
  }, [relativeEnd, relativeStart]);
  const handleCloseGuidedSetupTour = () => {
    setGuidedSetupTourVisible(false);
  };
  const handleGuidedSetupClick = (0, _react.useCallback)(() => {
    if (isGuidedSetupProgressDismissed) {
      trackMetric({
        metric: 'guided_setup_view_details_after_dismiss'
      });
    }
    handleCloseGuidedSetupTour();
    setIsDataAssistantFlyoutVisible(true);
  }, [trackMetric, isGuidedSetupProgressDismissed]);
  if (hasAnyData === undefined) {
    return /*#__PURE__*/_react.default.createElement(_loading_observability.LoadingObservability, null);
  }
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    isPageDataLoaded: isAllRequestsComplete,
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.observability.overview.pageTitle', {
        defaultMessage: 'Overview'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_header_actions.HeaderActions, {
        showTour: isGuidedSetupTourVisible,
        onGuidedSetupClick: handleGuidedSetupClick,
        onTourDismiss: handleCloseGuidedSetupTour,
        onTimeRangeRefresh: handleTimeRangeRefresh
      })],
      rightSideGroupProps: {
        responsive: true
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_observability_status_progress.ObservabilityStatusProgress, {
    onDismissClick: () => setGuidedSetupTourVisible(true),
    onViewDetailsClick: () => setIsDataAssistantFlyoutVisible(true)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_section.SectionContainer, {
    title: _i18n.i18n.translate('xpack.observability.overview.alerts.title', {
      defaultMessage: 'Alerts'
    }),
    appLink: {
      href: _paths.paths.observability.alerts,
      label: _i18n.i18n.translate('xpack.observability.overview.alerts.appLink', {
        defaultMessage: 'Show alerts'
      })
    },
    initialIsOpen: hasAnyData,
    hasError: false
  }, /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    chartProps: chartProps,
    featureIds: _alert_feature_ids.observabilityAlertFeatureIds,
    filter: esQuery,
    fullSize: true,
    timeRange: alertSummaryTimeRange
  }), /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    configurationId: _ruleDataUtils.AlertConsumers.OBSERVABILITY,
    flyoutSize: "s",
    featureIds: _alert_feature_ids.observabilityAlertFeatureIds,
    hideLazyLoader: true,
    id: ALERTS_TABLE_ID,
    pageSize: ALERTS_PER_PAGE,
    query: esQuery,
    showExpandToDetails: false,
    showAlertStatusWithFlapping: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_data_sections.DataSections, {
    bucketSize: bucketSize
  }), /*#__PURE__*/_react.default.createElement(_empty_sections.EmptySections, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, !!(newsFeed !== null && newsFeed !== void 0 && (_newsFeed$items = newsFeed.items) !== null && _newsFeed$items !== void 0 && _newsFeed$items.length) && /*#__PURE__*/_react.default.createElement(_news_feed.NewsFeed, {
    items: newsFeed.items.slice(0, 3)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_resources.Resources, null))))), isDataAssistantFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_data_assistant_flyout.DataAssistantFlyout, {
    onClose: () => setIsDataAssistantFlyoutVisible(false)
  }) : null);
}