"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverviewMetrics = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _ = require("../../..");
var _use_track_metric = require("../../../hooks/use_track_metric");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAPABILITIES_KEYS = ['logs', 'infrastructure', 'apm', 'uptime'];
const useOverviewMetrics = ({
  hasAnyData
}) => {
  const {
    application: {
      capabilities
    }
  } = (0, _public.useKibana)().services;
  const trackMetric = (0, _use_track_metric.useUiTracker)({
    app: 'observability-overview'
  });
  (0, _.useTrackPageview)({
    app: 'observability-overview',
    path: 'overview'
  });
  (0, _.useTrackPageview)({
    app: 'observability-overview',
    path: 'overview',
    delay: 15000
  });
  (0, _react.useEffect)(() => {
    if (hasAnyData !== true) {
      return;
    }
    CAPABILITIES_KEYS.forEach(feature => {
      var _capabilities$feature;
      const name = feature === 'infrastructure' ? 'metrics' : feature;

      // Track metric if the feature has been disabled, either because it
      // is missing or has show === false (manual disabling may not be
      // possible in all versions of Kibana)
      if (!capabilities[feature] || ((_capabilities$feature = capabilities[feature]) === null || _capabilities$feature === void 0 ? void 0 : _capabilities$feature.show) === false) {
        trackMetric({
          metric: `oblt_disabled_feature_${name}`
        });
      }

      // Track a separate metric if the feature is missing from the capabilities
      // (This usually means the plugin was auto-disabled by Kibana)
      if (!capabilities[feature]) {
        trackMetric({
          metric: `oblt_missing_feature_${name}`
        });
      }
    });
  }, [capabilities, hasAnyData, trackMetric]);
  return {
    trackMetric
  };
};
exports.useOverviewMetrics = useOverviewMetrics;