"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateBucketSize = calculateBucketSize;
exports.calculateTimeRangeBucketSize = calculateTimeRangeBucketSize;
var _date = require("../../../utils/date");
var _get_bucket_size = require("../../../utils/get_bucket_size");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function calculateBucketSize({
  start,
  end,
  timeBuckets
}) {
  if (start && end) {
    const {
      bucketSize,
      intervalString
    } = (0, _get_bucket_size.getBucketSize)({
      start,
      end,
      minInterval: _constants.DEFAULT_INTERVAL
    });
    timeBuckets.setInterval(intervalString);
    return {
      bucketSize,
      intervalString,
      dateFormat: timeBuckets.getScaledDateFormat()
    };
  }
}
function calculateTimeRangeBucketSize({
  from,
  to
}, timeBuckets) {
  const start = (0, _date.getAbsoluteTime)(from);
  const end = (0, _date.getAbsoluteTime)(to, {
    roundUp: true
  });
  return calculateBucketSize({
    start,
    end,
    timeBuckets
  });
}