"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderMenu = HeaderMenu;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
var _header_menu_portal = _interopRequireDefault(require("../../../components/shared/header_menu_portal"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderMenu() {
  const {
    appMountParameters: {
      setHeaderActionMenu
    }
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    http,
    theme
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_header_menu_portal.default, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme.theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: http.basePath.prepend('/app/integrations/browse'),
    iconType: "indexOpen"
  }, addDataLinkText)));
}
const addDataLinkText = _i18n.i18n.translate('xpack.observability.home.addData', {
  defaultMessage: 'Add integrations'
});