"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = HeaderActions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _date_picker = require("../../../components/shared/date_picker");
var _use_date_picker_context = require("../../../hooks/use_date_picker_context");
var _tour = require("../../../components/shared/tour");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderActions({
  showTour = false,
  onGuidedSetupClick,
  onTimeRangeRefresh,
  onTourDismiss
}) {
  const buttonRef = (0, _react.useRef)();
  const {
    relativeStart,
    relativeEnd,
    refreshInterval,
    refreshPaused
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const {
    endTour,
    isTourVisible
  } = (0, _tour.useObservabilityTourContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_date_picker.DatePicker, {
    rangeFrom: relativeStart,
    rangeTo: relativeEnd,
    refreshInterval: refreshInterval,
    refreshPaused: refreshPaused,
    width: "auto",
    onTimeRangeRefresh: onTimeRangeRefresh
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton
  // @ts-expect-error the EUI verson that kibana uses right now doesn't have the correct types
  , {
    buttonRef: buttonRef,
    color: "text",
    "data-test-subj": "guidedSetupButton",
    id: "guidedSetupButton",
    iconType: "wrench",
    onClick: () => {
      if (isTourVisible) {
        endTour();
      }
      onGuidedSetupClick();
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.guidedSetupButton",
    defaultMessage: "Data assistant"
  })), showTour ? /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep
  // @ts-expect-error the EUI verson that kibana uses right now doesn't have the correct types
  , {
    anchor: () => buttonRef.current,
    step: 1,
    stepsTotal: 1,
    isStepOpen: true,
    maxWidth: 400,
    onFinish: onTourDismiss,
    title: _i18n.i18n.translate('xpack.observability.overview.guidedSetupTourTitle', {
      defaultMessage: 'Data assistant is always available'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.overview.guidedSetupTourContent",
      defaultMessage: "If you're ever in doubt you can always access the data assistant and view your next steps by clicking here."
    })),
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11yHeaderActionsDismissButton",
      color: "text",
      flush: "right",
      size: "xs",
      onClick: onTourDismiss
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.overview.guidedSetupTourDismissButton",
      defaultMessage: "Dismiss"
    }))
  }) : null));
}