"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSections = DataSections;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _apm = require("../../../components/app/section/apm");
var _logs = require("../../../components/app/section/logs");
var _metrics = require("../../../components/app/section/metrics");
var _uptime = require("../../../components/app/section/uptime");
var _ux = require("../../../components/app/section/ux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataSections({
  bucketSize
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_logs.LogsSection, {
    bucketSize: bucketSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_metrics.MetricsSection, {
    bucketSize: bucketSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_apm.APMSection, {
    bucketSize: bucketSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_uptime.UptimeSection, {
    bucketSize: bucketSize
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ux.UXSection, {
    bucketSize: bucketSize
  }))));
}