"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Cases = Cases;
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../../common");
var _kibana_react = require("../../../utils/kibana_react");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
var _use_fetch_alert_detail = require("../../../hooks/use_fetch_alert_detail");
var _use_fetch_alert_data = require("../../../hooks/use_fetch_alert_data");
var _ = require("../../..");
var _paths = require("../../../config/paths");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Cases({
  permissions
}) {
  const {
    application: {
      navigateToUrl
    },
    cases: {
      ui: {
        getCases: CasesList
      }
    },
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    observabilityRuleTypeRegistry
  } = (0, _use_plugin_context.usePluginContext)();
  const [selectedAlertId, setSelectedAlertId] = (0, _react.useState)('');
  const [alertLoading, alert] = (0, _use_fetch_alert_detail.useFetchAlertDetail)(selectedAlertId);
  const handleFlyoutClose = () => setSelectedAlertId('');
  const handleShowAlertDetails = alertId => {
    setSelectedAlertId(alertId);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CasesList, {
    basePath: _common.casesPath,
    features: {
      alerts: {
        sync: false,
        isExperimental: false
      }
    },
    owner: [_common.observabilityFeatureId],
    permissions: permissions,
    ruleDetailsNavigation: {
      href: ruleId => prepend(_paths.paths.observability.ruleDetails(ruleId)),
      onClick: (ruleId, ev) => {
        const ruleLink = prepend(_paths.paths.observability.ruleDetails(ruleId));
        if (ev != null) {
          ev.preventDefault();
        }
        return navigateToUrl(ruleLink);
      }
    },
    showAlertDetails: handleShowAlertDetails,
    useFetchAlertData: _use_fetch_alert_data.useFetchAlertData
  }), alert && selectedAlertId !== '' && alertLoading === false ? /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(_.LazyAlertsFlyout, {
    alert: alert,
    observabilityRuleTypeRegistry: observabilityRuleTypeRegistry,
    onClose: handleFlyoutClose
  })) : null);
}