"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertActions = AlertActions;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/cases-plugin/common");
var _kibana_react = require("../../../utils/kibana_react");
var _use_get_user_cases_permissions = require("../../../hooks/use_get_user_cases_permissions");
var _is_alert_details_enabled = require("../../../utils/is_alert_details_enabled");
var _parse_alert = require("../helpers/parse_alert");
var _paths = require("../../../config/paths");
var _constants = require("../../rule_details/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_DETAILS_PAGE_ID = 'alert-details-o11y';
function AlertActions({
  config,
  data,
  ecsData,
  id: pageId,
  observabilityRuleTypeRegistry,
  refresh,
  setFlyoutAlert
}) {
  var _alert$fields$kibana, _alert$fields$kibana2, _alert$link;
  const {
    cases: {
      helpers: {
        getRuleIdFromEvent
      },
      hooks: {
        useCasesAddToNewCaseFlyout,
        useCasesAddToExistingCaseModal
      }
    },
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const userCasesPermissions = (0, _use_get_user_cases_permissions.useGetUserCasesPermissions)();
  const parseObservabilityAlert = (0, _react.useMemo)(() => (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry), [observabilityRuleTypeRegistry]);
  const dataFieldEs = data.reduce((acc, d) => ({
    ...acc,
    [d.field]: d.value
  }), {});
  const alert = parseObservabilityAlert(dataFieldEs);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const ruleId = (_alert$fields$kibana = alert.fields['kibana.alert.rule.uuid']) !== null && _alert$fields$kibana !== void 0 ? _alert$fields$kibana : null;
  const linkToRule = pageId !== _constants.RULE_DETAILS_PAGE_ID && ruleId ? prepend(_paths.paths.observability.ruleDetails(ruleId)) : null;
  const alertId = (_alert$fields$kibana2 = alert.fields['kibana.alert.uuid']) !== null && _alert$fields$kibana2 !== void 0 ? _alert$fields$kibana2 : null;
  const linkToAlert = pageId !== ALERT_DETAILS_PAGE_ID && alertId ? prepend(_paths.paths.observability.alertDetails(alertId)) : null;
  const caseAttachments = (0, _react.useMemo)(() => {
    var _ecsData$_id, _ecsData$_index;
    return ecsData !== null && ecsData !== void 0 && ecsData._id ? [{
      alertId: (_ecsData$_id = ecsData === null || ecsData === void 0 ? void 0 : ecsData._id) !== null && _ecsData$_id !== void 0 ? _ecsData$_id : '',
      index: (_ecsData$_index = ecsData === null || ecsData === void 0 ? void 0 : ecsData._index) !== null && _ecsData$_index !== void 0 ? _ecsData$_index : '',
      type: _common.CommentType.alert,
      rule: getRuleIdFromEvent({
        ecs: ecsData,
        data: data !== null && data !== void 0 ? data : []
      })
    }] : [];
  }, [ecsData, getRuleIdFromEvent, data]);
  const onSuccess = (0, _react.useCallback)(() => {
    refresh();
  }, [refresh]);
  const createCaseFlyout = useCasesAddToNewCaseFlyout({
    onSuccess
  });
  const selectCaseModal = useCasesAddToExistingCaseModal({
    onSuccess
  });
  const closeActionsPopover = () => {
    setIsPopoverOpen(false);
  };
  const toggleActionsPopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const handleAddToNewCaseClick = () => {
    createCaseFlyout.open({
      attachments: caseAttachments
    });
    closeActionsPopover();
  };
  const handleAddToExistingCaseClick = () => {
    selectCaseModal.open({
      getAttachments: () => caseAttachments
    });
    closeActionsPopover();
  };
  const actionsMenuItems = [...(userCasesPermissions.create && userCasesPermissions.read ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-existing-case-action",
    key: "addToExistingCase",
    onClick: handleAddToExistingCaseClick,
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alerts.actions.addToCase', {
    defaultMessage: 'Add to existing case'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-new-case-action",
    key: "addToNewCase",
    onClick: handleAddToNewCaseClick,
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alerts.actions.addToNewCase', {
    defaultMessage: 'Add to new case'
  }))] : []), ...(!!linkToRule ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "viewRuleDetails",
    key: "viewRuleDetails",
    href: linkToRule
  }, _i18n.i18n.translate('xpack.observability.alertsTable.viewRuleDetailsButtonText', {
    defaultMessage: 'View rule details'
  }))] : []), ...[(0, _is_alert_details_enabled.isAlertDetailsEnabledPerApp)(alert, config) && linkToAlert ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "viewAlertDetailsPage",
    key: "viewAlertDetailsPage",
    href: linkToAlert
  }, _i18n.i18n.translate('xpack.observability.alertsTable.viewAlertDetailsButtonText', {
    defaultMessage: 'View alert details'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "viewAlertDetailsFlyout",
    key: "viewAlertDetailsFlyout",
    onClick: () => {
      closeActionsPopover();
      setFlyoutAlert(alert);
    }
  }, _i18n.i18n.translate('xpack.observability.alertsTable.viewAlertDetailsButtonText', {
    defaultMessage: 'View alert details'
  }))]];
  const actionsToolTip = actionsMenuItems.length <= 0 ? _i18n.i18n.translate('xpack.observability.alertsTable.notEnoughPermissions', {
    defaultMessage: 'Additional privileges required'
  }) : _i18n.i18n.translate('xpack.observability.alertsTable.moreActionsTextLabel', {
    defaultMessage: 'More actions'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.observability.alertsTable.viewInAppTextLabel', {
      defaultMessage: 'View in app'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.observability.alertsTable.viewInAppTextLabel', {
      defaultMessage: 'View in app'
    }),
    color: "text",
    href: prepend((_alert$link = alert.link) !== null && _alert$link !== void 0 ? _alert$link : ''),
    iconType: "eye",
    size: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: actionsToolTip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": actionsToolTip,
      color: "text",
      "data-test-subj": "alertsTableRowActionMore",
      display: "empty",
      iconType: "boxesHorizontal",
      onClick: toggleActionsPopover,
      size: "s"
    })),
    closePopover: closeActionsPopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: actionsMenuItems
  }))));
}