"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValuesList = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _common = require("@kbn/observability-shared-plugin/common");
var _use_es_search = require("./use_es_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uniqueValues = (values, prevValues) => {
  return (0, _lodash.uniqBy)([...values, ...prevValues], 'label');
};
const getIncludeClause = (sourceField, query) => {
  if (!query) {
    return '';
  }
  let includeClause = '';
  if (sourceField === _common.TRANSACTION_URL) {
    // for the url we also match leading text
    includeClause = `*.${query.toLowerCase()}.*`;
  } else {
    if (query[0].toLowerCase() === query[0]) {
      // if first letter is lowercase we also add the capitalize option
      includeClause = `(${query}|${(0, _lodash.capitalize)(query)}).*`;
    } else {
      // otherwise we add lowercase option prefix
      includeClause = `(${query}|${query.toLowerCase()}).*`;
    }
  }
  return includeClause;
};
const useValuesList = ({
  sourceField,
  dataViewTitle,
  query = '',
  filters,
  time,
  label,
  keepHistory,
  cardinalityField
}) => {
  const [debouncedQuery, setDebounceQuery] = (0, _react.useState)(query);
  const [values, setValues] = (0, _react.useState)([]);
  const {
    from,
    to
  } = time !== null && time !== void 0 ? time : {};
  (0, _useDebounce.default)(() => {
    setDebounceQuery(query);
  }, 350, [query]);
  (0, _react.useEffect)(() => {
    if (!query) {
      // in case query is cleared, we don't wait for debounce
      setDebounceQuery(query);
    }
  }, [query]);
  const includeClause = getIncludeClause(sourceField, query);
  const {
    data,
    loading
  } = (0, _use_es_search.useEsSearch)((0, _use_es_search.createEsParams)({
    index: dataViewTitle,
    body: {
      query: {
        bool: {
          filter: [...(filters !== null && filters !== void 0 ? filters : []), ...(from && to ? [{
            range: {
              '@timestamp': {
                gte: from,
                lte: to
              }
            }
          }] : [])]
        }
      },
      size: 0,
      aggs: {
        values: {
          terms: {
            field: sourceField,
            size: 50,
            ...(query ? {
              include: includeClause
            } : {})
          },
          ...(cardinalityField ? {
            aggs: {
              count: {
                cardinality: {
                  field: cardinalityField
                }
              }
            }
          } : {})
        }
      }
    }
  }), [debouncedQuery, from, to, JSON.stringify(filters), dataViewTitle, sourceField], {
    name: `get${label.replace(/\s/g, '')}ValuesList`
  });
  (0, _react.useEffect)(() => {
    var _data$aggregations, _valueBuckets$map;
    const valueBuckets = data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.values.buckets;
    const newValues = (_valueBuckets$map = valueBuckets === null || valueBuckets === void 0 ? void 0 : valueBuckets.map(({
      key: value,
      doc_count: count,
      count: aggsCount
    }) => {
      if (aggsCount) {
        return {
          count: aggsCount.value,
          label: String(value)
        };
      }
      return {
        count,
        label: String(value)
      };
    })) !== null && _valueBuckets$map !== void 0 ? _valueBuckets$map : [];
    if (keepHistory) {
      setValues(prevState => {
        return uniqueValues(newValues, prevState);
      });
    } else {
      setValues(newValues);
    }
  }, [data, keepHistory, loading, query]);
  return {
    values,
    loading
  };
};
exports.useValuesList = useValuesList;