"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRouteParams = useRouteParams;
var t = _interopRequireWildcard(require("io-ts"));
var _reactRouterDom = require("react-router-dom");
var _Either = require("fp-ts/lib/Either");
var _PathReporter = require("io-ts/lib/PathReporter");
var _routes = require("../routes");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getQueryParams(location) {
  const urlSearchParms = new URLSearchParams(location.search);
  const queryParams = {};
  urlSearchParms.forEach((value, key) => {
    queryParams[key] = value;
  });
  return queryParams;
}

/**
 * Extracts query and path params from the url and validate it against the type defined in the route file.
 * It removes any aditional item which is not declared in the type.
 * @param params
 */
function useRouteParams(pathName) {
  const location = (0, _reactRouterDom.useLocation)();
  const pathParams = (0, _reactRouterDom.useParams)();
  const queryParams = getQueryParams(location);
  const {
    query,
    path
  } = _routes.routes[pathName].params;
  const rts = {
    queryRt: query ? t.exact(query) : t.strict({}),
    pathRt: path ? t.exact(path) : t.strict({})
  };
  const queryResult = rts.queryRt.decode(queryParams);
  const pathResult = rts.pathRt.decode(pathParams);
  if ((0, _Either.isLeft)(queryResult)) {
    console.error(_PathReporter.PathReporter.report(queryResult)[0]);
  }
  if ((0, _Either.isLeft)(pathResult)) {
    console.error(_PathReporter.PathReporter.report(pathResult)[0]);
  }
  return {
    query: (0, _Either.isLeft)(queryResult) ? {} : queryResult.right,
    path: (0, _Either.isLeft)(pathResult) ? {} : pathResult.right
  };
}