"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaSpace = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKibanaSpace = () => {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    data: space,
    loading,
    error
  } = (0, _.useFetcher)(() => {
    var _services$spaces;
    return (_services$spaces = services.spaces) === null || _services$spaces === void 0 ? void 0 : _services$spaces.getActiveSpace();
  }, [services.spaces]);
  return {
    space,
    loading,
    error
  };
};
exports.useKibanaSpace = useKibanaSpace;