"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchRuleSummary = useFetchRuleSummary;
var _react = require("react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _translations = require("../pages/rule_details/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchRuleSummary({
  ruleId,
  http
}) {
  const [ruleSummary, setRuleSummary] = (0, _react.useState)({
    isLoadingRuleSummary: true,
    ruleSummary: undefined,
    errorRuleSummary: undefined
  });
  const fetchRuleSummary = (0, _react.useCallback)(async () => {
    setRuleSummary(oldState => ({
      ...oldState,
      isLoading: true
    }));
    try {
      const response = await (0, _public.loadRuleSummary)({
        http,
        ruleId
      });
      setRuleSummary(oldState => ({
        ...oldState,
        isLoading: false,
        ruleSummary: response
      }));
    } catch (error) {
      setRuleSummary(oldState => ({
        ...oldState,
        isLoading: false,
        errorRuleSummary: (0, _translations.RULE_LOAD_ERROR)(error instanceof Error ? error.message : typeof error === 'string' ? error : '')
      }));
    }
  }, [ruleId, http]);
  (0, _react.useEffect)(() => {
    fetchRuleSummary();
  }, [fetchRuleSummary]);
  return {
    ...ruleSummary,
    reloadRuleSummary: fetchRuleSummary
  };
}