"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchIndices = useFetchIndices;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchIndices() {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchIndices'],
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.get(`/api/index_management/indices`, {
          signal
        });
        return response;
      } catch (error) {
        throw new Error(`Something went wrong. Error: ${error}`);
      }
    }
  });
  return {
    isLoading,
    isError,
    isSuccess,
    indices: data,
    refetch
  };
}