"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetUserAlertsPermissions = exports.getAlertsPermissions = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsPermissions = (uiCapabilities, featureId) => {
  if (!featureId || !uiCapabilities[featureId]) {
    return {
      crud: false,
      read: false,
      loading: false,
      featureId
    };
  }
  return {
    crud: featureId === 'apm' ? uiCapabilities[featureId]['alerting:save'] : uiCapabilities[featureId].save,
    read: featureId === 'apm' ? uiCapabilities[featureId]['alerting:show'] : uiCapabilities[featureId].show,
    loading: false,
    featureId
  };
};
exports.getAlertsPermissions = getAlertsPermissions;
const useGetUserAlertsPermissions = (uiCapabilities, featureId) => {
  const [alertsPermissions, setAlertsPermissions] = (0, _react.useState)({
    crud: false,
    read: false,
    loading: true,
    featureId: null
  });
  (0, _react.useEffect)(() => {
    if (!featureId || !uiCapabilities[featureId]) {
      setAlertsPermissions({
        crud: false,
        read: false,
        loading: false,
        featureId: null
      });
    } else {
      setAlertsPermissions(currentAlertPermissions => {
        if (currentAlertPermissions.featureId === featureId) {
          return currentAlertPermissions;
        }
        return getAlertsPermissions(uiCapabilities, featureId);
      });
    }
  }, [alertsPermissions.featureId, featureId, uiCapabilities]);
  return alertsPermissions;
};
exports.useGetUserAlertsPermissions = useGetUserAlertsPermissions;