"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateSlo = useUpdateSlo;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUpdateSlo() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(({
    sloId,
    slo
  }) => {
    const body = JSON.stringify(slo);
    return http.put(`/api/observability/slos/${sloId}`, {
      body
    });
  }, {
    mutationKey: ['updateSlo'],
    onSuccess: (_data, {
      slo: {
        name
      }
    }) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observability.slo.update.successNotification', {
        defaultMessage: 'Successfully updated {name}',
        values: {
          name
        }
      }));
      queryClient.invalidateQueries(['fetchSloList']);
      queryClient.invalidateQueries(['fetchHistoricalSummary']);
    },
    onError: (error, {
      slo: {
        name
      }
    }) => {
      toasts.addError(new Error(String(error)), {
        title: _i18n.i18n.translate('xpack.observability.slo.update.errorNotification', {
          defaultMessage: 'Something went wrong when updating {name}',
          values: {
            name
          }
        })
      });
    }
  });
}