"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchIndices = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchIndices = () => {
  return {
    isLoading: false,
    isError: false,
    isSuccess: true,
    indices: [...Array(10).fill(0).map((_, i) => ({
      name: `.index-${i}`
    })), ...Array(10).fill(0).map((_, i) => ({
      name: `.some-other-index-${i}`
    }))],
    refetch: function () {}
  };
};
exports.useFetchIndices = useFetchIndices;